﻿using KarleyLibrary.Erweiterungen;
using System.Collections.Generic;
using System.Data;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;

namespace WK5.Core.Services
{
    /// <summary>
    /// Stellt Funktionalitäten für den Umgang mit <see cref="Zolltarif"/>nummern zur Verfügung
    /// </summary>
    public class ZolltarifService
    {
        /// <summary>
        /// Sucht in der Datenbank auf Basis des <see cref="ZolltarifFilter"/>s nach Zolltarifen.
        /// </summary>
        /// <param name="filter"></param>
        /// <param name="fbController"></param>
        /// <returns></returns>
        public async IAsyncEnumerable<Zolltarif> GetZolltarifeAsync(ZolltarifFilter filter, FbController2 fbController)
        {
            string sql = filter.ToSqlQuery(fbController);

            var data = await fbController.SelectDataAsync(sql);

            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new Zolltarif(), row);
            }
        }
    }
}
