﻿using KarleyLibrary.Erweiterungen;
using System.Data;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core.Models;
using WK5.Core.Models.Tools.Lagerregal;

namespace WK5.Core.Services
{
    // TODO: MK: Der Service stammt noch aus der Urversion der WK5. Die Funktionen hierdrin sollten durch IModelService ersetzt werden und auf Dapper umgestellt werden. Alles mit 0 Verweisen ist nur aus Kompatibilitätsgründen noch vorhanden.
    public class WerbemittelService
    {
        public async Task<WerbemittelCollection> GetWerbemittel()
        {
            using FbController2 _fbController = new FbController2();
            WerbemittelCollection werbemittelCollection = new WerbemittelCollection();

            var werbemittelData = await _fbController.SelectDataAsync("SELECT * FROM WK5_WERBEMITTEL");

            foreach (DataRow row in werbemittelData.Rows)
            {
                var werbemittel = ObjectErweiterung.DataRowZuObjekt(new Werbemittel(), row);
                await GetUnterwarengruppen(werbemittel);
                werbemittelCollection.Add(werbemittel);
            }

            return werbemittelCollection;
        }

        public async Task<Werbemittel?> GetWerbemittel(string name)
        {
            using FbController2 _fbController = new FbController2();
            _fbController.AddParameter("@WERB_A_NAME", name.ToUpper());
            var row = await _fbController.SelectRowAsync("SELECT * FROM WK5_WERBEMITTEL WHERE WERB_A_NAME = @WERB_A_NAME");

            var werbemittel = row is null ? null : ObjectErweiterung.DataRowZuObjekt(new Werbemittel(), row);

            if (werbemittel is null)
            {
                return null;
            }

            await GetUnterwarengruppen(werbemittel);

            return werbemittel;
        }
        /// <summary>
        /// Liefert das nächste Werbemittel für einen zu packenden Auftrag
        /// </summary>
        /// <param name="auftrag"></param>
        /// <returns></returns>
        public async Task<Werbemittel?> GetWerbemittel(PackAuftrag? auftrag)
        {
            using FbController2 _fbController = new FbController2();
            if (auftrag is null)
            {
                return null;
            }

            _fbController.AddParameter("@KUNDENNUMMER", auftrag.Kundennummer);
            var data = await _fbController.SelectDataAsync(@"SELECT 
	WB.*, 
	CASE WHEN(WBZK.WZK_N_ANZAHL IS NULL) THEN
		0
	ELSE
		WBZK.WZK_N_ANZAHL
	END AS ANZAHL_VERSENDET,
    WZU_A_UGRUPPE
FROM WK5_WERBEMITTEL WB
LEFT JOIN WK5_WERBEMITTEL_ZU_KUNDE WBZK ON (UPPER(WB.WERB_A_NAME) = UPPER(WBZK.WZK_A_WERBEMITTEL) AND WBZK.WZK_A_KUNDENNR = @KUNDENNUMMER)
LEFT JOIN WK5_WERBEMITTEL_ZU_UGRUPPE WBZU ON (UPPER(WBZU.WZU_A_NAME) = UPPER(WB.WERB_A_NAME))
WHERE WERB_L_AKTIV = 'Y' 
AND (WB.WERB_L_OHNEZEITRAUM = 'Y' OR (WB.WERB_L_OHNEZEITRAUM = 'N' AND WERB_D_VON <= CURRENT_DATE AND WERB_D_BIS >= CURRENT_DATE))
AND WERB_N_VERSENDEN > CASE WHEN(WBZK.WZK_N_ANZAHL IS NULL) THEN
		0
	ELSE
		WBZK.WZK_N_ANZAHL
	END
ORDER BY WERB_N_ORDER DESC");

            Werbemittel? werbemittel = null;

            if (data.Rows.Count != 0)
            {
                // Werbemittel mit passender Unterwarengruppe sollen gezielt genommen werden
                foreach (var unterwarengruppe in auftrag.GetUnterwarengruppen())
                {
                    var suche =
                        from DataRow myRow in data.Rows
                        where myRow["WZU_A_UGRUPPE"] as string == unterwarengruppe
                        select myRow;

                    if (suche.Any())
                    {
                        werbemittel = ObjectErweiterung.DataRowZuObjekt(new Werbemittel(), suche.First());
                    }
                }

                // Wenn bis hier nichts gefunden wurde, dann nehme das erste Element.
                werbemittel = ObjectErweiterung.DataRowZuObjekt(new Werbemittel(), data.Rows[0]);

                // Wir müssen noch die Unterwarengruppen für unser Objekt definieren
                var sucheUnterwarengruppen =
                    from DataRow myRow in data.Rows
                    where myRow["WERB_A_NAME"] as string == werbemittel.Name
                    select myRow;

                foreach (DataRow unterwarengruppeRow in sucheUnterwarengruppen)
                {
                    string? unterwarengruppe = unterwarengruppeRow["WZU_A_UGRUPPE"] as string;
                    if (unterwarengruppe is not null)
                    {
                        werbemittel.Unterwarengruppen.Add(unterwarengruppe);
                    }
                }
            }

            return werbemittel;

        }

        private async Task GetUnterwarengruppen(Werbemittel werbemittel)
        {
            using FbController2 _fbController = new FbController2();
            var data = await _fbController.SelectDataAsync("SELECT * FROM WK5_WERBEMITTEL_ZU_UGRUPPE WHERE WZU_A_NAME = @WZU_A_NAME");

            foreach (DataRow unterwarengruppeRow in data.Rows)
            {
                string? unterwarengruppe = unterwarengruppeRow["WZU_A_UGRUPPE"] as string;
                if (unterwarengruppe is not null)
                {
                    werbemittel.Unterwarengruppen.Add(unterwarengruppe);
                }
            }
        }
    }
}
