﻿using KarleyLibrary.Erweiterungen;
using System.Collections.Generic;
using System.Data;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;

namespace WK5.Core.Services
{
    public class WarengruppenService
    {

        public async IAsyncEnumerable<Warengruppe> GetWarengruppenAsync(WarengruppenFilter filter, FbController2 fbController)
        {
            DataTable data = await fbController.SelectDataAsync(filter.ToSqlQuery(fbController));

            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new Warengruppe(), row);
            }
        }
        public async IAsyncEnumerable<Unterwarengruppe> GetUnterwarengruppeAsync(UnterwarengruppenFilter filter, FbController2 fbController)
        {
            DataTable data = await fbController.SelectDataAsync(filter.ToSqlQuery(fbController));

            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new Unterwarengruppe(), row);
            }
        }

    }
}
