﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Runtime.CompilerServices;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;

namespace WK5.Core.Services
{
    public class TelefonService
    {
        public async Task CreateAsync(Telefonat input, FbController2 fbController)
        {

            fbController.AddParameter("@TELE_A_TELNR", input.Telefonnummer);
            fbController.AddParameter("@TELE_A_KUNDENNR", input.Kundennummer);
            fbController.AddParameter("@TELE_A_LINE", input.Line);
            fbController.AddParameter("@TELE_A_INOUT", input.InOurOut);
            fbController.AddParameter("@TELE_A_LINEANGENOMMEN", input.LineAngenommen);
            fbController.AddParameter("@TELE_N_DAUER", input.Dauer);
            fbController.AddParameter("@TELE_TIMESTAMP", input.Timestamp);

            int newId = Convert.ToInt32(await fbController.FetchObjectAsync(@"INSERT INTO TELEFONATE
(
TELE_A_TELNR, TELE_A_KUNDENNR, TELE_A_LINE, TELE_A_INOUT,
TELE_A_LINEANGENOMMEN, TELE_N_DAUER, TELE_TIMESTAMP
)
VALUES
(
@TELE_A_TELNR, @TELE_A_KUNDENNR, @TELE_A_LINE, @TELE_A_INOUT,
@TELE_A_LINEANGENOMMEN, @TELE_N_DAUER, @TELE_TIMESTAMP
) RETURNING TELE_N_ID"));

            input.Id = newId;
        }


        public async Task<Telefonat?> GetLastCallAsync(FbController2 fbController)
        {
            DataRow? row = await fbController.SelectRowAsync("SELECT FIRST 1 * FROM TELEFONATE ORDER BY TELE_N_ID DESC");

            return row is null ? null : ObjectErweiterung.DataRowZuObjekt(new Telefonat(), row);
        }

        public async Task<string> GetKundeByTelefonnummerAsync(string telefonnummer, FbController2 fbController)
        {
            string kundennummer = string.Empty;
            

            fbController.AddParameter("@TELEFONNUMMER", telefonnummer);
            fbController.AddParameter("@TELEFONNUMMER2", $"0{telefonnummer}");
            DataRow? row = await fbController.SelectRowAsync("SELECT FIRST 1 KUND_A_NR FROM KUNDEN WHERE KUND_A_TEL1 = @TELEFONNUMMER OR KUND_A_TEL1 = @TELEFONNUMMER2");

            if(row is not null)
            {
                kundennummer = row.Field<string>("KUND_A_NR") ?? string.Empty;
            }

            if (kundennummer == string.Empty)
            {
                fbController.AddParameter("@TELEFONNUMMER", telefonnummer);
                fbController.AddParameter("@TELEFONNUMMER2", $"0{telefonnummer}");
                row = await fbController.SelectRowAsync(@"SELECT 
KUND_A_NR FROM kunden 
LEFT JOIN ANSPRECHPARTNER ON KUND_A_NR = PART_A_KUNDNR 
where KUND_A_TEL1 = @TELEFONNUMMER 
OR KUND_A_TEL1 = @TELEFONNUMMER2 
OR KUND_A_TEL2 = @TELEFONNUMMER 
OR KUND_A_TEL2 = @TELEFONNUMMER2 
OR PART_A_TELEFON = @TELEFONNUMMER 
OR PART_A_TELEFON = @TELEFONNUMMER2");
               
                if(row is not null)
                {
                    kundennummer = row.Field<string>("KUND_A_NR") ?? string.Empty;
                    
                }
            }

            return kundennummer;  
        }


        
    }
}
