﻿using KarleyLibrary.Erweiterungen;
using System.Collections.Generic;
using System.Data;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;

namespace WK5.Core.Services
{
    public class PreisgruppenService
    {
        public async IAsyncEnumerable<Preisgruppe> GetPreisgruppenAsync(PreisgruppenFilter filter, FbController2 fbController)
        {
            var data = await fbController.SelectDataAsync(filter.ToSqlQuery(fbController));
            foreach (DataRow row in data.Rows)
            {
                if (row is not null)
                {
                    yield return ObjectErweiterung.DataRowZuObjekt(new Preisgruppe(), row);
                }
            }
        }
    }
}
