﻿using System.Collections.Generic;
using System.Data;
using System.Runtime.CompilerServices;
using System.Threading;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;

namespace WK5.Core.Services
{
    public class PaketService
    {
        public async IAsyncEnumerable<W4Paket?> GetPaketeAsync(PaketFilter filter, [EnumeratorCancellation] CancellationToken cancellationToken)
        {
            using FbController2 fbController = new FbController2();
            string sql = filter.ToSqlQuery(fbController);

            var data = await fbController.SelectDataAsync(sql);

            foreach (DataRow row in data.Rows)
            {
                if (!cancellationToken.IsCancellationRequested)
                {
                    int pakeid = row.Field<int>("PAKE_N_ID");
                    if (pakeid > 0)
                    {
                        yield return await W4Paket.GetPaketAsync(pakeid);
                    }
                }

                //row.Delete();
            }
        }
    }
}
