﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core.Basis;
using WK5.Core.Models;

namespace WK5.Core.Services
{
    public class MitarbeiterService : IModelService<Personal, int>
    {
        public async Task CreateAsync(Personal mitarbeiter, FbController2 fbController)
        {
            fbController.AddParameter("@PERS_A_VORNAME", mitarbeiter.PERS_A_VORNAME);
            fbController.AddParameter("@PERS_A_NAME", mitarbeiter.PERS_A_NAME);
            fbController.AddParameter("@PERS_L_VERTRETER", mitarbeiter.PERS_L_VERTRETER);
            fbController.AddParameter("@PERS_L_INAKTIV", mitarbeiter.PERS_L_INAKTIV);
            mitarbeiter.PERS_N_NR = Convert.ToInt32(await fbController.FetchObjectAsync(@"INSERT INTO PERSONAL
(
PERS_A_VORNAME, PERS_A_NAME, PERS_L_INAKTIV, PERS_L_VERTRETER
)
VALUES
(
@PERS_A_VORNAME, @PERS_A_NAME, @PERS_L_INAKTIV, @PERS_L_VERTRETER
)
RETURNING PERS_N_NR"));
        }
        public async Task UpdateAsync(Personal mitarbeiter, FbController2 fbController)
        {
            fbController.AddParameter("@PERS_A_VORNAME", mitarbeiter.PERS_A_VORNAME);
            fbController.AddParameter("@PERS_A_NAME", mitarbeiter.PERS_A_NAME);
            fbController.AddParameter("@PERS_L_INAKTIV", mitarbeiter.PERS_L_INAKTIV);
            fbController.AddParameter("@PERS_L_VERTRETER", mitarbeiter.PERS_L_VERTRETER);
            fbController.AddParameter("@PERS_N_NR", mitarbeiter.PERS_N_NR);
            await fbController.FetchObjectAsync(@"UPDATE PERSONAL SET
PERS_A_VORNAME = @PERS_A_VORNAME, PERS_A_NAME = @PERS_A_NAME, PERS_L_INAKTIV = @PERS_L_INAKTIV, PERS_L_VERTRETER = @PERS_L_VERTRETER
WHERE
PERS_N_NR = @PERS_N_NR");

        }

        public Task<Personal?> GetAsync(int identifier, FbController2 fbController)
        {
            throw new NotImplementedException();
        }

    }
}
