﻿using System.Collections.Generic;
using System.Data;
using System.Linq;

namespace WK5.Core.Services
{
    /// <summary>
    /// Stellt eine Wrapper Klasse für das Ergebnis des Jahresumsatz eines Lieferanten dar
    /// </summary>
    public class Jahresumsatz
    {
        private readonly Dictionary<int, decimal> _umsatzWerte;

        public int Jahr { get; set; }
        public decimal Januar => GetValueAt(1);
        public decimal Februar => GetValueAt(2);
        public decimal März => GetValueAt(3);
        public decimal April => GetValueAt(4);
        public decimal Mai => GetValueAt(5);
        public decimal Juni => GetValueAt(6);
        public decimal Juli => GetValueAt(7);
        public decimal August => GetValueAt(8);
        public decimal September => GetValueAt(9);
        public decimal Oktober => GetValueAt(10);
        public decimal November => GetValueAt(11);
        public decimal Dezember => GetValueAt(12);

        public decimal Total => Januar + Februar + März + April + Mai + Juni + Juli + August + September + Oktober + November + Dezember;

        private decimal this[int i]
        {
            get
            {
                return GetValueAt(i);
            }
        }

        public decimal GetValueAt(int index)
        {
            if (_umsatzWerte.ContainsKey(index))
            {
                return _umsatzWerte[index];
            }
            return 0.0m;
        }

        private void SetValueAt(int index, decimal value)
        {
            if (_umsatzWerte.ContainsKey(index))
            {
                _umsatzWerte[index] = value;
            }
            else
            {
                _umsatzWerte.Add(index, value);
            }
        }

        public Jahresumsatz(Dictionary<int, decimal> werte)
        {
            _umsatzWerte = werte;
        }

        private Jahresumsatz()
        {
            _umsatzWerte = new Dictionary<int, decimal>();
        }

        public static Jahresumsatz FromList(List<Jahresumsatz> umsätze)
        {
            Jahresumsatz tmp = new Jahresumsatz();
            foreach (var umsatz in umsätze)
            {
                tmp += umsatz;
            }
            return tmp;
        }

        public IEnumerable<decimal> ToIEnumerable()
        {
            List<decimal> values = new List<decimal>();
            for (int i = 1; i <= 12; i++)
            {
                values.Add(GetValueAt(i));
            }
            return values.AsEnumerable();
        }
        public List<JahresumsatzDataItem> ToDataItem(int year)
        {
            List<JahresumsatzDataItem> data = new List<JahresumsatzDataItem>();
            for (int i = 1; i <= 12; i++)
            {
                data.Add(new JahresumsatzDataItem
                {
                    Month = i,
                    Revenue = GetValueAt(i)
                });
            }
            return data;
        }

        public static Jahresumsatz operator +(Jahresumsatz a, Jahresumsatz b)
        {
            Jahresumsatz tmp = new Jahresumsatz() { Jahr = a.Jahr == b.Jahr ? a.Jahr : 0 };
            for (int i = 1; i <= 12; i++)
            {
                tmp.SetValueAt(i, a.GetValueAt(i) + b.GetValueAt(i));
            }
            return tmp;
        }

        public static Jahresumsatz operator -(Jahresumsatz a, Jahresumsatz b)
        {
            Jahresumsatz tmp = new Jahresumsatz() { Jahr = a.Jahr == b.Jahr ? a.Jahr : 0 };
            for (int i = 1; i <= 12; i++)
            {
                tmp.SetValueAt(i, a.GetValueAt(i) - b.GetValueAt(i));
            }
            return tmp;
        }
    }

    public class JahresumsatzDataItem
    {
        public int Month { get; set; }
        public decimal Revenue { get; set; }
    }
}
