﻿using KarleyLibrary.Erweiterungen;
using System.Collections.Generic;
using System.Data;
using WK5.Core.Basis.Filter;
using WK5.Core.Models;

namespace WK5.Core.Services
{
    public class HerstellerService
    {

        public async IAsyncEnumerable<Hersteller> GetHerstellerAsync(HerstellerFilter filter)
        {
            using FbController2 fbController = new FbController2();
            string sql = filter.ToSqlQuery(fbController);

            var data = await fbController.SelectDataAsync(sql);

            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt<Hersteller>(new Hersteller(), row);
            }
        }
    }
}
