﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Runtime.CompilerServices;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core.Basis.Filter.Statistik;
using WK5.Core.Models;

namespace WK5.Core.Services
{
    public class ErloesKalkulatorService
    {
        private readonly BelegService _belegService;


        public ErloesKalkulatorService(BelegService belegService)
        {
            _belegService = belegService;
        }

        /// <summary>
        /// Lädt sich die Belegdaten aus einem gegebenen Zeitraum und berechnet anhand dieser die Erloes Results
        /// </summary>
        /// <param name="BELE_A_TYP">Der Belegtyp von dem sich die Belege geladen werden sollen</param>
        /// <param name="From">Das Datum ab dem die Belege geladen werden sollen</param>
        /// <param name="To">Das Datum bis zu dem die Belege geladen werden sollen/param>
        /// <param name="cancellationToken">Ein CancellationToken um eine Loop Operation ggf abzubrechen</param>
        /// <param name="personal">Die Personalnummer zu der sich die Belege geladen werden sollen</param>
        /// <param name="vertreter">Die Vertreternummer zu der sich die Belege geladen werden sollen</param>
        /// <returns>Gibt ein <see cref="IAsyncEnumerable{T}"/> of <see cref="ErlöskalkulatorResult"/> zurück das die berechneten Daten enthält</returns>
        public async Task<List<ErlöskalkulatorResult>> GetBelegeAsync(ErlöskalkulatorFilter filter, FbController2 fbController)
        {
            return await fbController.SelectDataAsync<ErlöskalkulatorResult>(filter.ToSqlQuery(fbController), new
            {
                BELE_A_TYP = EnumHelper.GetBelegTypString(filter.Typ),
                FROM = filter.From,
                TO = filter.To,
                BELE_N_VERTRETER = filter.VertreterId,
                BELE_N_LASTUSER = filter.BearbeiterId
            });
        }
    }

    public class ErlöskalkulatorResult
    {
        public int BELE_N_NR { get; set; }
        public string BELE_A_TYP { get; set; } = String.Empty;
        public int BELE_N_VERTRETER { get; set; }
        public int BELE_N_LASTUSER  { get; set; }
        public decimal EK { get; set; }
        public decimal VK { get; set; }
        public decimal Erlös
        {
            get
            {
                return VK - EK;
            }
        }
        public decimal GewinnProzent => VK <= 0.0m ? -100.0m : (VK - EK) / VK * 100.0m;
        public string Class
        {
            get
            {
                if (EK <= 0.0m || VK <= 0.0m)
                {
                    return "table-warning";
                }
                else
                {
                    if (this.Erlös < 0.0m)
                    {
                        return "table-danger";
                    }
                    else if (GewinnProzent <= 10.0m)
                    {
                        return "table-secondary";
                    }
                    else if (GewinnProzent >= 20.0m)
                    {
                        return "table-success";
                    }                    

                    return String.Empty;
                }
            }
        }

        

        
    }
}
