﻿using System.Threading.Tasks;

namespace WK5.Core.Services
{
    /// <summary>
    /// Stellt Funktionen zur Datenkorrektur zur Verfügung
    /// </summary>
    public class DatenReorganisationService
    {
        /// <summary>
        /// Berechnet den gesamten Artikelbedarf neu.
        /// </summary>
        /// <param name="fbController"></param>
        /// <returns></returns>
        public async Task ReorgArtikelBedarfAsync(FbController2 fbController)
        {
            await fbController.RunProcedureAsync("CALC_GESAMTARTIKELBEDARF");
        }
        /// <summary>
        /// Berechnet den gesamten Artikelbestand neu.
        /// </summary>
        /// <param name="fbController"></param>
        /// <returns></returns>
        public async Task ReorgArtikelBestandAsync(FbController2 fbController)
        {
            await fbController.RunProcedureAsync("CALC_GESAMTARTIKELBESTAND");
        }
        /// <summary>
        /// Berechnet die Gesamtmenge an offenen Mengen von Bestellungen neu.
        /// </summary>
        /// <param name="fbController"></param>
        /// <returns></returns>
        public async Task ReorgOffeneBestellungenAsync(FbController2 fbController)
        {
            await fbController.RunProcedureAsync("CALC_GESAMTOFFENEBESTELLMENGE");
        }
    }
}
