﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core.Models;

namespace WK5.Core.Services
{
    public class BestelldispoService
    {
        public Bestellung Bestellung { get; } = new Bestellung();
        public Lieferant? Lieferant { get; private set; }

        public async Task SetLieferantAsync(Lieferant? lieferant)
        {
            Lieferant = lieferant;
            Bestellung.Positionen.Clear();

            if(Lieferant is not null)
            {
                Bestellung.LieferantenId = Lieferant.LIEF_N_NR;
                Bestellung.BEST_N_ZAHLUNG = Lieferant.LIEF_N_ZABD;
                Bestellung.LieferbedingungId = Lieferant.LIEF_N_LIBD;
                Bestellung.Währung = Lieferant.LIEF_A_WAEHRUNG;
                Bestellung.Versicherungskosten = Lieferant.LIEF_WK5_N_VERSICHERKOSTEN;
                Bestellung.Verpackungskosten = Lieferant.LIEF_WK5_N_VERPACKKOSTEN;
                Bestellung.Versandkosten = Lieferant.LIEF_WK5_N_VERSANDKOSTEN;
                var ansprechpartner = await AnsprechpartnerLieferant.GetAnsprechpartnerAsync(Lieferant.LIEF_N_NR).FirstOrDefaultAwaitAsync(x => ValueTask.FromResult(x.LIEP_L_HAUPTPARTNER));
                Bestellung.BEST_A_PARTNER = ansprechpartner?.LIEP_A_NAME ?? String.Empty;
            }
            else
            {
                Bestellung.LieferantenId = 0;
                Bestellung.BEST_N_ZAHLUNG = 0;
                Bestellung.LieferbedingungId = 0;
                Bestellung.Währung = "EUR";
                Bestellung.Versicherungskosten = 0;
                Bestellung.Verpackungskosten = 0;
                Bestellung.Versandkosten = 0;
                Bestellung.BEST_A_PARTNER = String.Empty;
            }
            

        }



    }
}
