﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Threading.Tasks;
using WK5.Core.Basis;
using WK5.Core.Models;

namespace WK5.Core.Services
{
    public class BelegtextService : IModelService<Belegtext, int>
    {
        public async Task CreateAsync(Belegtext input, FbController2 fbController)
        {
            input.BETE_TIMESTAMP = DateTime.Now;
            input.BETE_N_LASTUSER = fbController.UserId;

            fbController.AddParameter("@BETE_B_TEXT", input.BETE_B_TEXT);
            fbController.AddParameter("@BETE_A_VORSCHAU", input.BETE_A_VORSCHAU);
            fbController.AddParameter("@BETE_TIMESTAMP", input.BETE_TIMESTAMP);
            fbController.AddParameter("@BETE_N_LASTUSER", input.BETE_N_LASTUSER);
            input.BETE_N_NR = Convert.ToInt32(await fbController.FetchObjectAsync(@"INSERT INTO WK5_BELEGTEXTE
(
BETE_B_TEXT, BETE_A_VORSCHAU, BETE_TIMESTAMP, BETE_N_LASTUSER
)
VALUES
(
@BETE_B_TEXT, @BETE_A_VORSCHAU, @BETE_TIMESTAMP, @BETE_N_LASTUSER
)
RETURNING BETE_N_NR"));
        }

        public async Task<Belegtext?> GetAsync(int identifier, FbController2 fbController)
        {
            fbController.AddParameter("@BETE_A_NR", identifier);
            DataRow? row = await fbController.SelectRowAsync("SELECT * FROM WK5_BELEGTEXTE WHERE BETE_N_NR = @BETE_N_NR");

            return row is null ? null : ObjectErweiterung.DataRowZuObjekt(new Belegtext(), row);
        }

        public async Task UpdateAsync(Belegtext input, FbController2 fbController)
        {
            input.BETE_TIMESTAMP = DateTime.Now;
            input.BETE_N_LASTUSER = fbController.UserId;

            fbController.AddParameter("@BETE_B_TEXT", input.BETE_B_TEXT);
            fbController.AddParameter("@BETE_A_VORSCHAU", input.BETE_A_VORSCHAU);
            fbController.AddParameter("@BETE_TIMESTAMP", input.BETE_TIMESTAMP);
            fbController.AddParameter("@BETE_N_LASTUSER", input.BETE_N_LASTUSER);
            fbController.AddParameter("@BETE_N_NR", input.BETE_N_NR);
            await fbController.QueryAsync(@"UPDATE WK5_BELEGTEXTE SET 
BETE_B_TEXT = @BETE_B_TEXT, BETE_A_VORSCHAU = @BETE_A_VORSCHAU,
BETE_TIMESTAMP = @BETE_TIMESTAMP, BETE_N_LASTUSER = @BETE_N_LASTUSER
WHERE
BETE_N_NR = @BETE_N_NR");
        }      
        public async Task<Belegtext> DeleteAsync(Belegtext input, FbController2 fbController)
        {
            fbController.AddParameter("@BETE_N_NR", input.BETE_N_NR);
            await fbController.QueryAsync("DELETE FROM WK5_BELEGTEXTE WHERE BETE_N_NR = @BETE_N_NR");
            return input;
        }
        public async IAsyncEnumerable<Belegtext> GetAllAsync(FbController2 fbController)
        {
            DataTable data = await fbController.SelectDataAsync("SELECT * FROM WK5_BELEGTEXTE ORDER BY BETE_A_VORSCHAU");

            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new Belegtext(), row);
            }

        }
    }
}
