﻿using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Runtime.CompilerServices;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using WK5.Core.Email;
using WK5.Core.Models;
using WK5.Core.Models.Tools.AdressReminder;

namespace WK5.Core.Services
{
    public class AdressReminderService
    {
        public async IAsyncEnumerable<AdressReminderOutput> GetReminder(int vertreter, int months, [EnumeratorCancellation] CancellationToken cancellationToken)
        {
            using FbController2 fbController = new FbController2();


            StringBuilder sb = new StringBuilder();
            sb.Append("SELECT * FROM KUNDEN WHERE KUND_WK5_L_REMINDER = 'Y'");
            if (vertreter > 0)
            {
                fbController.AddParameter("@VERTRETER", vertreter);
                sb.Append(" AND KUND_N_VERTRETNUMM = @VERTRETER");
            }
            DataTable data = await fbController.SelectDataAsync(sb.ToString());
            KundenkontaktService kundenkontaktService = new KundenkontaktService();
            foreach (DataRow row in data.Rows)
            {
                Kunde kunde = ObjectErweiterung.DataRowZuObjekt(new Kunde(), row);

                List<Kundenkontakt> kukos = await Kundenkontakt.GetKundenkontakteAsync(kunde.KUND_A_NR, 99, cancellationToken).ToListAsync();

                if (kukos.Count > 3)
                {
                    foreach (Kundenkontakt kontakt in kukos)
                    {
                        await kundenkontaktService.DeleteAsync(kontakt, fbController);
                    }

                    kunde.KUND_WK5_L_REMINDER = false;
                    await Kunde.UpdateKundeAsync(kunde, 2);

                    continue;
                }

                fbController.AddParameter("@KUNDENNR", kunde.KUND_A_NR);
                int angebotNr = Convert.ToInt32(await fbController.FetchObjectAsync("SELECT FIRST 1 BELE_N_NR FROM BELEGE WHERE BELE_A_KUNDENNR = @KUNDENNR AND BELE_A_TYP = 'AN' ORDER BY BELE_D_DATE DESC"));

                AdressReminderOutput output = new AdressReminderOutput()
                {
                    Reminder = kukos,
                    Kunde = kunde,
                    LetztesAngebot = await Angebot.GetAngebotAsync(angebotNr, fbController)

                };


                if (kukos.Count > 0)
                {
                    DateTime lastCheck = DateTime.Now.AddMonths(months * -1);
                    DateTime lastReminder = kukos.OrderByDescending(x => x.KUKO_D_DATE).First().KUKO_D_DATE;

                    if (lastReminder < lastCheck)
                    {
                        yield return output;
                    }
                }
                else
                {
                    yield return output;
                }


            }
        }

        public async Task<KarleyBrowserInterfaceEmail?> GetEmailText(AdressReminderOutput output)
        {
            StringBuilder emailBuilder = new StringBuilder();
            string? recipient = String.Empty;

            if (output.LetztesAngebot is null)
            {
                return null;
            }

            
            Ansprechpartner? partner = await Ansprechpartner.GetAnsprechpartnerByNameAsync(output.LetztesAngebot.Kundennummer, output.LetztesAngebot.Ansprechpartner);

            if (partner is null || partner.PART_N_NR < 0)
            {
                emailBuilder.Append("<h2>Sehr geehrter Damen und Herren,</h2>");
                recipient = output.Kunde.KUND_A_EMAIL;
            }
            else
            {
                emailBuilder.Append($"<h2>{partner.PART_A_BRIEFANREDE} {partner.PART_A_NAME},</h2>");
                recipient = partner.PART_A_EMAIL;
            }

            emailBuilder.Append("<br/>");
            emailBuilder.Append("<br/>");
            emailBuilder.Append($"Ich hatte Ihnen am {output.LetztesAngebot.BELE_D_DATE.ToString("dddd, dd MMMM yyyy")} ein Angebot zu folgenden Produkten zukommen lassen:");
            emailBuilder.Append("<br/>");

            emailBuilder.Append("<ul>");
            foreach (Belegposition belegpos in output.LetztesAngebot.Positionen)
            {
                if (belegpos.Menge > 0)
                    emailBuilder.Append($"<li>{(belegpos.Menge < 2 ? String.Empty : $"{belegpos.Menge}x ")}{belegpos.Bezeichnung1}</li>");
            }
            emailBuilder.Append("</ul>");
            emailBuilder.Append("<br/>");
            emailBuilder.Append("<p>Ich wollte mich bei Ihnen erkundigen ob soweit noch Interesse an den Produkten besteht.</p>");
            emailBuilder.Append("<p>Sollten Sie Fragen zu den Produkten oder dem Angebot haben, stehe ich Ihnen selbstverständlich zur Verfügung.</p>");
            emailBuilder.Append("<br/>");
            emailBuilder.Append("<p>Mit freundlichen Grüßen,</p>");
            emailBuilder.Append("<p>%(Benutzer Name)</p>");

            emailBuilder.Append("<span>Karley Deutschland GmbH</span><br/>");
            emailBuilder.Append("<span>Herner Str. 15b - 45657 Recklinghausen</span><br/>");
            emailBuilder.Append("<span>Tel: +49(0)2361 979 231 - 0</span><br/>");
            emailBuilder.Append("<span>Fax: +49(0)2361 979 231 - 90</span><br/>");
            emailBuilder.Append("<span><a href=\"www.etikett-aufkleber.de\">www.etikett-aufkleber.de</a></span><br/>");
            emailBuilder.Append("<span><a href=\"www.dvd-roboter.com\">www.dvd-roboter.com</a></span><br/>");
            emailBuilder.Append("<span><a href=\"www.kassenbedarf.de\">www.kassenbedarf.de</a></span><br/>");
            emailBuilder.Append("<span><a href=\"www.karley.de\">www.karley.de</a></span><br/>");
            emailBuilder.Append("<span><a href=\"www.karley.eu\">www.karley.eu</a></span><br/>");
            emailBuilder.Append("<br/>");
            emailBuilder.Append("<span>Handelsregister Recklinghausen</span><br/>");
            emailBuilder.Append("<span>HRB 5605</span><br/>");
            emailBuilder.Append("<span>DE251382615</span><br/>");
            emailBuilder.Append("<span>Geschäftsführer: Karsten Ley</span>");

            return new KarleyBrowserInterfaceEmail
            {
                Absender = GlobalConfig.EmailInfoEU,
                Empfänger = recipient ?? String.Empty,
                Content = emailBuilder.ToString(),
                Betreff = $"Angebot AN-{output.LetztesAngebot.Belegnummer} vom {output.LetztesAngebot.BELE_D_DATE.ToShortDateString()}"
            };
        }
    }
}
