﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using WK5.Core.Models.Versand;
using WK5.Core.PageModels.Tools.Versand;

namespace WK5.Core.PageModels.Verkauf.RMAS
{
    public class RmaVersandInput
    {
        public bool EmailSenden { get; set; }
        public int AnzahlPakete { get; private set; } = 0;
        public List<PaketInput> Pakete { get; set; } = new List<PaketInput>();
        public CourierArt CourierArt { get; set; } = CourierArt.UST;


        public RmaVersandInput()
        {
            AddPaket();
        }

        public void AddPaket(decimal gewicht = 0)
        {
            Pakete.Add(new PaketInput { Paketnummer = ++AnzahlPakete, Gewicht = gewicht });
        }
        public void RemovePaket()
        {
            Pakete.RemoveAt(--AnzahlPakete);
        }
    }
}
