﻿using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;

namespace WK5.Core.PageModels.Tools.Versand
{
    public class VersandModalInput
    {
        [ValidateComplexType]
        public List<PaketInput> Pakete { get; set; } = new List<PaketInput>();
        public int AnzahlPakete { get; private set; } = 0;
        public bool MailSenden { get; set; } = true;

        public void AddPaket(decimal gewicht = 0)
        {
            Pakete.Add(new PaketInput { Paketnummer = ++AnzahlPakete, Gewicht = gewicht });
        }

        public void RemovePaket()
        {
            Pakete.RemoveAt(--AnzahlPakete);
        }
    }
}
