﻿using MbeSoap;
using System;
using System.ComponentModel.DataAnnotations;


namespace WK5.Core.PageModels.Tools.Versand
{
    /// <summary>
    /// Stellt ein Model zu validierung von Paketen dar, welches keine Trackingnummer in der Eingabe vorraussetzt.
    /// </summary>
    public class PaketInput
    {
        public int Paketnummer { get; set; }
        [Required]
        [Range(0.1, 31)]
        public decimal Gewicht { get; set; }
        public string Trackingnummer { get; set; } = "";

        public decimal Width { get; set; }
        public decimal Length { get; set; }
        public decimal Heigth { get; set; }
        public ItemType ToItemType()
        {
            return new ItemType
            {
                Weight = Gewicht,
                Dimensions = new DimensionsType
                {
                    Width = Width,
                    Height = Heigth,
                    Lenght = Length
                }
            };
        }
    }
}
