﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using WK5.Core.Models.Versand;

namespace WK5.Core.PageModels.Tools.Versand
{
    public class ManuellBelegVersandInput
    {

        public BelegTyp BelegTyp { get; set; }
        [Range(10000, Int32.MaxValue)]
        public int Belegnummer { get; set; }
        public Courier Courier { get => _courier; set { _courier = value; OnCourierChange(); } }
        public int AnzahlPakete { get; private set; } = 0;
        [ValidateComplexType]
        public List<PaketInputManuell> Pakete { get; set; } = new List<PaketInputManuell>();

        private Courier _courier = Courier.UPS;

        public ManuellBelegVersandInput()
        {
            AddPaket();
        }

        public void AddPaket(decimal gewicht = 0)
        {
            PaketInputManuell input = new PaketInputManuell { Paketnummer = ++AnzahlPakete, Gewicht = gewicht };
            if (Courier == Courier.OHNETRACKINGNUMMER)
            {
                input.Trackingnummer = "OHNE";
            }

            Pakete.Add(input);
        }

        public void RemovePaket()
        {
            Pakete.RemoveAt(--AnzahlPakete);
        }

        public void OnCourierChange()
        {


            foreach (PaketInputManuell input in this.Pakete)
            {
                input.Trackingnummer = this.Courier == Courier.OHNETRACKINGNUMMER ? "OHNE" : "";
            }
        }
    }
}
