﻿using MbeSoap;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Threading.Tasks;
using WK5.Core.Models.Versand;
using WK5.Core.OpenCart.MachMich;

namespace WK5.Core.PageModels.Tools.Versand
{
    public class MachMichInput
    {
        #region Allgemein
        public int MachMichOrderId { get; set; } = 0;
        public CourierArt Versandart { get; set; } = CourierArt.UST;
        #endregion
        #region Empfänger Daten
        [Required]
        [MaxLength(35)]
        public string Name { get; set; } = "";
        [Required]
        [MaxLength(35)]
        public string Firmenname { get; set; } = "";
        [MaxLength(100)]
        public string Nickname { get; set; } = "";
        [Required]
        [MaxLength(100)]
        public string Adresse1 { get; set; } = "";
        [MaxLength(35)]
        public string Adresse2 { get; set; } = "";
        [MaxLength(35)]
        public string Adresse3 { get; set; } = "";
        [Required]
        [MaxLength(2)]
        public string Land { get; set; } = "DE";
        [Required]
        [DataType(DataType.PostalCode)]
        [MaxLength(12)]
        public string Postleitzahl { get; set; } = "";
        [Required]
        [MaxLength(50)]
        public string Ort { get; set; } = "";
        [Required]
        [DataType(DataType.PhoneNumber)]
        [MaxLength(50)]
        public string Telefonnummer { get; set; } = "";
        [Required]
        [DataType(DataType.EmailAddress)]
        [MaxLength(75)]
        public string Email { get; set; } = "";

        #endregion
        #region Konstruktoren
        public MachMichInput()
        {
            AddPaket();
        }
        #endregion
        #region Paket Daten
        public int AnzahlPakete { get; private set; } = 0;

        [ValidateComplexType]
        public List<PaketInput> Pakete { get; set; } = new List<PaketInput>();
        public void AddPaket(decimal gewicht = 0)
        {
            Pakete.Add(new PaketInput { Paketnummer = ++AnzahlPakete, Gewicht = gewicht });
        }

        public void RemovePaket()
        {
            Pakete.RemoveAt(--AnzahlPakete);
        }

        [Required]
        [MaxLength(100)]
        public string PaketBeschreibung { get; set; } = String.Empty;
        #endregion

        #region MBE Helper


        public ShipmentType ToShipmentType() => new ShipmentType
        {
            COD = false,
            Courier = "UPS",
            CourierService = Versandart.ToString(),
            Description = PaketBeschreibung,
            ShipperType = ShipmentTypeShipperType.COURIERLDV,
            Insurance = false,
            PackageType = ShipmentTypePackageType.GENERIC
        };

        public List<ItemType> PaketeToItemType()
        {
            List<ItemType> pakete = new List<ItemType>();
            foreach (var paket in this.Pakete)
            {
                pakete.Add(new ItemType
                {
                    Dimensions = new DimensionsType
                    {
                        Height = 1.0m,
                        Width = 1.0m,
                        Lenght = 1.0m
                    },
                    Weight = paket.Gewicht
                });
            }

            return pakete;
        }
        #endregion

        public async Task<MachMichOrder?> GetOrderAsync()
        {
            return this.MachMichOrderId <= 0 ? null : await MachMichOrder.GetOrderAsync(this.MachMichOrderId);
        }



    }
}
