﻿using System;
using System.ComponentModel.DataAnnotations;

namespace WK5.Core.PageModels.Tools.Statistik
{
    public class VerkaufNachWarengruppeInput
    {
        [Required]
        public DateTime From { get; set; }
        [Required]
        public DateTime To { get; set; }
        [Required]
        public int Limit { get; set; }
        [Required]
        public string Warengruppe { get; set; }
        public string Unterwarengruppe { get; set; }

        public bool DisplayNull { get; set; }

        public VerkaufNachWarengruppeInput()
        {
            From = DateTime.Now.AddYears(-1);
            To = DateTime.Now;
            Limit = 20;
            Warengruppe = String.Empty;
            Unterwarengruppe = String.Empty;
            DisplayNull = false;
        }
    }
}
