﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using WK5.Core.Basis.Filter;

namespace WK5.Core.PageModels.Tools.Statistik
{
    public class ArtikelNachKundeInput
    {
        [Required]
        public DateTime From { get; set; }
        [Required]
        public DateTime To { get; set; }
        

        
        public List<ArtikelNachKunde_ArtikelInput> Artikel { get; set; }

        public ArtikelNachKundeInput()
        {
            From = DateTime.Now.AddMonths(-6);
            To = DateTime.Now;
            Artikel = new List<ArtikelNachKunde_ArtikelInput>();
            this.AddArtikel();
        }

        public void AddArtikel()
        {
            Artikel.Add(new ArtikelNachKunde_ArtikelInput { Artikelnummer = String.Empty, Menge = 0.0m });
        }

        public void RemoveArtikel()
        {
            Artikel.RemoveAt(Artikel.Count - 1);
        }
    }
}
