﻿using System;
using WK5.Core.Models;
using WK5.Core.Models.Lager;

namespace WK5.Core.PageModels.Tools
{
    public class RechnungsPrüfungInput
    {
        public Zugang Zugang { get; set; }
        public bool Exportieren { get; set; }
        public string Bemerkung { get; set; } = String.Empty;

        public RechnungsPrüfungInput(Zugang zugang)
        {
            Zugang = zugang;
        }

        public bool ExportierenErlaubt(ZahlungsbedingungCollection zahlungsbedingungen)
        {
            Zahlungsbedingung? zahlungsbedingung = zahlungsbedingungen[Zugang.ZUGA_N_ZABD];
            if (zahlungsbedingung is null)
            {
                return false;
            }

            if (Zugang.ZUGA_N_ZABD is 0 || (Zugang.WK5_ZUGA_N_NETTO_GESAMTRECHNUNG is 0 && (Zugang.WK5_ZUGA_L_TEILZUGANG || Zugang.AnzahlZugängeZurRechnungsnummer > 1)))
            {
                return false;
            }
            else if (Zugang.WK5_ZUGA_N_NETTO_GESAMTRECHNUNG != Zugang.ZUGA_N_NETTO && (Zugang.WK5_ZUGA_L_TEILZUGANG || Zugang.AnzahlZugängeZurRechnungsnummer > 1))
            {
                return false;
            }
            else if (String.IsNullOrWhiteSpace(Zugang.LIEF_A_BIC) || String.IsNullOrWhiteSpace(Zugang.LIEF_A_IBAN))
            {
                // Wir brauchen nur Bankdaten, bei Rechnungen
                if (zahlungsbedingung.ZABD_L_RECHNUNG)
                {
                    return false;
                }
            }

            return true;
        }
        public string GetRowClass(ZahlungsbedingungCollection zahlungsbedingungen)
        {

            if (Zugang.ZUGA_N_ZABD is 0 || (Zugang.WK5_ZUGA_N_NETTO_GESAMTRECHNUNG is 0 && (Zugang.WK5_ZUGA_L_TEILZUGANG || Zugang.AnzahlZugängeZurRechnungsnummer > 1)))
            {
                return "table-danger";
            }
            else if (Zugang.WK5_ZUGA_N_NETTO_GESAMTRECHNUNG != Zugang.ZUGA_N_NETTO && (Zugang.WK5_ZUGA_L_TEILZUGANG || Zugang.AnzahlZugängeZurRechnungsnummer > 1))
            {
                return "table-warning";
            }
            else if (zahlungsbedingungen.IstRechnung(Zugang.ZUGA_N_ZABD) && String.IsNullOrWhiteSpace(Zugang.LIEF_A_BIC) || String.IsNullOrWhiteSpace(Zugang.LIEF_A_IBAN))
            {
                return "bg-violett";
            }
            else
            {
                return String.Empty;
            }
        }
    }
}
