﻿using System;
using System.ComponentModel.DataAnnotations;

namespace WK5.Core.PageModels.Tools.Gewichtsberechner
{
    public class ManuellGewichtsberechnerInput
    {
        [Required]
        [MaxLength(35)]
        public string Name { get; set; } = "";
        [Required]
        [MaxLength(100)]
        public string Straße { get; set; } = "";
        [Required]
        [MaxLength(2)]
        public string Land { get; set; } = "DE";
        [Required]
        [MaxLength(12)]
        public string Postleitzahl { get; set; } = "";
        [Required]
        [MaxLength(50)]
        public string Ort { get; set; } = "";
        [Required]
        [Range(0.1, 400)]
        public decimal Gewicht { get; set; }

    }
}
