﻿using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using WK5.Core.PageModels.Tools.Versand;

namespace WK5.Core.PageModels.Tools.Gewichtsberechner
{
    public class GewichtsberechnerInput
    {
        public int AnzahlPakete { get; private set; } = 0;

        [ValidateComplexType]
        public GewichtsberechnerDestinationInfoInput DestinationInfo { get; } = new GewichtsberechnerDestinationInfoInput();
        [ValidateComplexType]
        public List<PaketInput> Pakete { get; } = new List<PaketInput>();

        public GewichtsberechnerInput()
        {
            AddPaket();
        }

        public void AddPaket()
        {
            Pakete.Add(new PaketInput
            {
                Paketnummer = ++AnzahlPakete
            });
        }

        public void RemovePaket()
        {
            Pakete.RemoveAt(--AnzahlPakete);
        }
    }
}
