﻿using MbeSoap;
using System;
using System.ComponentModel.DataAnnotations;

namespace WK5.Core.PageModels.Tools.Gewichtsberechner
{
    public class GewichtsberechnerDestinationInfoInput
    {
        [Required]
        [MaxLength(50)]
        public string City { get; set; } = String.Empty;
        [Required]
        [MaxLength(2)]
        public string Country { get; set; } = "DE";
        [Required]
        [MaxLength(8)] // MBE kann zwar zwölf, die W4 aber nur 8.
        public string ZipCode { get; set; } = String.Empty;
        [MaxLength(2)]
        public string State { get; set; } = String.Empty;
        public int SubzoneId { get; set; }

        public DestinationInfoType ToDestinationInfoType()
        {
            return new DestinationInfoType
            {
                City = City,
                Country = Country,
                idSubzone = SubzoneId,
                ZipCode = ZipCode
            };
        }
    }
}
