﻿using KarleyLibrary.Attributes;
using KarleyLibrary.Erweiterungen;
using System.ComponentModel.DataAnnotations;
using System.Text;
using WK5.Core.Models;

namespace WK5.Core.PageModels.Stammdaten.Lieferanten
{
    public class LieferantenPartnerInput
    {
        public int Lieferantennummer { get; set; }
        public int Nummer { get; set; } = -1;
        public string? Name { get; set; }
        public string? Bereich { get; set; }
        public string? Telefon { get; set; }
        public string? Handy { get; set; }
        public string? Fax { get; set; }
        public string? Email { get; set; }
        public string? Adresstext { get; set; }
        public string? Anrede { get; set; }
        private string? _notiz;
        public string? Notiz
        {
            get
            {
                if (_notiz is null)
                {
                    return null;
                }

                return StringErweiterung.ConvertEncoding(_notiz, Encoding.GetEncoding("ISO-8859-1"), Encoding.UTF8);
            }
            set
            {
                if (value is null)
                {
                    _notiz = null;
                    return;
                }

                _notiz = StringErweiterung.ConvertEncoding(value, Encoding.UTF8, Encoding.GetEncoding("ISO-8859-1"));
            }
        }

        public bool Hauptansprechpartner { get; set; }

        public LieferantenPartnerInput()
        {

        }

        public LieferantenPartnerInput(int nummer)
        {
            this.Nummer = nummer;
        }

        public LieferantenPartner ToLieferantenPartner()
        {
            return new LieferantenPartner
            {
                LIEP_N_LIEFNR = Lieferantennummer,
                LIEP_N_NR = Nummer,
                LIEP_A_NAME = Name,
                LIEP_A_BEREICH = Bereich,
                LIEP_A_TELEFON = Telefon,
                LIEP_A_TELEFAX = Fax,
                LIEP_A_HANDY = Handy,
                LIEP_A_EMAIL = Email,
                LIEP_A_ADRESSTEXT = Adresstext,
                LIEP_A_ANREDE = Anrede,
                LIEP_A_NOTIZ = Notiz,
                LIEP_L_HAUPTPARTNER = Hauptansprechpartner
            };
        }

    }
}
