﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using WK5.Core.Models;
using WK5.Core.Models.VatChecker;
using WK5.Core.Services;

namespace WK5.Core.PageModels.Stammdaten.Lieferanten
{
    /// <summary>
    /// repräsentiert die Daten der Benutzereingabe auf der Lieferanten Seite
    /// </summary>
    public class LieferantenInput
    {

        public int Lieferantennummer { get; }
        #region Properties        

        private int _chartFrom;
        private int _chartTo;
        public int ChartCount { get => ChartTo - ChartFrom; }

        public int ChartFrom
        {
            get => _chartFrom;
            set
            {
                if (value > ChartTo)
                {
                    return;
                }
                else
                {
                    _chartFrom = value;
                }
            }
        }
        public int ChartTo
        {
            get => _chartTo; set
            {
                if (value < ChartFrom)
                {
                    return;
                }
                else
                {
                    _chartTo = value;
                }
            }
        }
        public string? Partner { get; set; }
        public string? Name1 { get; set; }
        public string? Name2 { get; set; }
        public string? Strasse { get; set; } = String.Empty;
        public string? Ort { get; set; } = String.Empty;
        public string? Land { get; set; }
        public string? Postleitzahl { get; set; }

        private string? _telefon1;
        public string? Telefon1
        {
            get { return _telefon1; }
            set
            {
                if (value != null && value.Equals(String.Empty))
                {
                    value = null;
                }

                _telefon1 = value;
            }
        }

        private string? _telefon2;
        public string? Telefon2
        {
            get { return _telefon2; }
            set
            {
                if (value != null && value.Equals(String.Empty))
                {
                    value = null;
                }

                _telefon2 = value;
            }
        }
        public string? Fax { get; set; }


        private string? _email;
        public string? Email
        {
            get => _email;
            set
            {
                _email = value;
                AutoCompleteHomepage();
            }

        }
        public string? Homepage { get; set; }
        public string? UnsereKundennummer { get; set; }

        public string? Notiz { get; set; }

        public string? Suchbegriff { get; set; }
        public int LieferbedingungId { get; set; } = 1;
        public int ZahlungsbedingungId { get; set; } = 22; // Vorkasse ist standard

        public int RuecklieferAdressId { get; set; }

        public decimal Mindestbestellwert { get; set; }
        public decimal FrachtfreiAb { get; set; }
        public string? Kreditorennummer { get; set; }
        public string? UstId { get; set; }

        public bool Drittland { get; set; }
        public bool EULieferant { get; set; }

        public bool AbweichendeRuecklieferadresse { get; set; } = false;
        public string Waehrung { get; set; } = "EUR";

        public decimal Rabatt { get; set; }
        public string? Bankkonto { get; set; }
        public string? IBAN { get; set; }
        public string? Bankleitzahl { get; set; }
        public string? BIC { get; set; }
        public string? Kontoinhaber { get; set; }
        public string? Bankname { get; set; }

        public bool Bescheinigung13bUSTG { get; set; }

        public DateTime Bescheinigung13bUSTGGueltigBis { get; set; }
        public bool Bescheinigung48bESTG { get; set; }

        public DateTime Bescheinigung48bESTGGueltigBis { get; set; }

        public bool Mindestlohnbescheinigung { get; set; }

        public int Lieferantengruppe { get; set; }

        public bool Umsatzsteuer { get; set; } = true;

        //Standard vollen MwSt satz
        public int MwStId { get; set; } = 1;

        public bool Rueckgaberecht { get; set; }
        public int RueckgaberechtTage { get; set; }
        public bool Gesperrt { get; set; } = false;

        public string? Selektionsmerkmal1 { get; set; }
        public string? Selektionsmerkmal2 { get; set; }
        public string? Selektionsmerkmal3 { get; set; }

        public bool Bonus { get; set; }
        public decimal Bonus1Prozent { get; set; }
        public decimal Bonus1Wert { get; set; }

        public decimal Bonus2Prozent { get; set; }
        public decimal Bonus2Wert { get; set; }

        public decimal Bonus3Prozent { get; set; }
        public decimal Bonus3Wert { get; set; }


        public decimal Versandkosten { get; set; }
        public decimal Verpackungskosten { get; set; }
        public decimal Versicherungskosten { get; set; }

        public bool DirektLieferungErlaubt { get; set; }
        public string? ShopUsername { get; set; }
        public string? ShopPasswort { get; set; }

        public bool Autoimport { get; set; }

        public decimal Mindermengenzuschlag { get; set; }

        public string Warnhinweise { get; set; } = string.Empty;
        #endregion

        public bool Eigenlieferant { get; set; }

        public LieferantenPartnerInput? SelectedAnsprechpartner { get; set; }
        public List<LieferantenPartnerInput> Ansprechpartner { get; } = new List<LieferantenPartnerInput>();
        public LieferantenAnschriftInput? SelectedAnschrift { get; set; }
        public List<LieferantenAnschriftInput> Anschriften { get; } = new List<LieferantenAnschriftInput>();



        public void AddAnschrift()
        {
            var newAnschrift = new LieferantenAnschriftInput()
            {
                Lieferantennummer = Lieferantennummer
            };
            Anschriften.Add(newAnschrift);
            SelectedAnschrift = newAnschrift;
        }

        public void RemoveAnschrift()
        {
            if (SelectedAnschrift is null)
            {
                return;
            }

            SelectedAnschrift = Anschriften.Remove(SelectedAnschrift) ? null : SelectedAnschrift;
        }

        public void AddAnsprechpartner()
        {
            var newPartner = new LieferantenPartnerInput()
            {
                Lieferantennummer = Lieferantennummer,
                Fax = Fax ?? String.Empty,
                Telefon = Telefon1 ?? String.Empty,

            };
            Ansprechpartner.Add(newPartner);
            SelectedAnsprechpartner = newPartner;
        }

        public void RemoveAnsprechpartner()
        {
            if (SelectedAnsprechpartner is null)
            {
                return;
            }

            Ansprechpartner.Remove(SelectedAnsprechpartner);
            SelectedAnsprechpartner = null;
        }

        public void SetHauptAnsprechpartner(LieferantenPartnerInput partner)
        {
            foreach (var item in Ansprechpartner)
            {
                if (item != partner)
                {
                    item.Hauptansprechpartner = false;
                }
            }
        }


        private void AutoCompleteHomepage()
        {
            if (!String.IsNullOrWhiteSpace(Email))
            {
                string domain = Regex.Replace(Email, @".*@", "");
                if (!GlobalConfig.Freemails.Contains(domain))
                {
                    Homepage = domain;
                }
            }
        }

        public Lieferant ToLieferant()
        {
            return new Lieferant
            {
                LIEF_A_NAME1 = Name1 ?? String.Empty,
                LIEF_A_NAME2 = Name2,
                LIEF_A_SUCHCODE = Suchbegriff,
                LIEF_A_STR = Strasse,
                LIEF_A_LAND = Land!,
                LIEF_A_PLZ = Postleitzahl,
                LIEF_A_ORT = Ort,
                LIEF_A_TEL1 = Telefon1,
                LIEF_A_TEL2 = Telefon2,
                LIEF_A_FAX = Fax,
                LIEF_A_EMAIL = Email,
                LIEF_A_URL = Homepage,
                LIEF_A_KUNDENNR = UnsereKundennummer,
                LIEF_A_NOTIZ = Notiz,
                LIEF_N_LIBD = LieferbedingungId,
                LIEF_N_ZABD = ZahlungsbedingungId,
                LIEF_N_MIDBESTWERT = Mindestbestellwert,
                LIEF_N_FRACHTFR_AB = FrachtfreiAb,
                LIEF_A_KREDITORNR = Kreditorennummer,
                LIEF_A_USTIDNR = UstId,
                LIEF_L_EUKUNDE = EULieferant,
                LIEF_L_AUSLAND = Drittland,
                LIEF_L_LIEFABWEICHEND = AbweichendeRuecklieferadresse,
                LIEF_A_WAEHRUNG = Waehrung,
                LIEF_N_RABATT = Rabatt,
                LIEF_A_KONTO = Bankkonto,
                LIEF_A_IBAN = IBAN,
                LIEF_A_BLZ = Bankleitzahl,
                LIEF_A_BIC = BIC,
                LIEF_A_KONTOINHABER = Kontoinhaber,
                LIEF_A_BANKNAME = Bankname,
                LIEF_L_PARGR13B = Bescheinigung13bUSTG,
                LIEF_D_PARGR13B = Bescheinigung13bUSTGGueltigBis,
                LIEF_L_PARGR48B = Bescheinigung48bESTG,
                LIEF_D_PARGR48B = Bescheinigung48bESTGGueltigBis,
                LIEF_L_MINDESTLOHN = Mindestlohnbescheinigung,
                LIEF_N_GRUPPE = Lieferantengruppe,
                LIEF_L_MWST = Umsatzsteuer,
                LIEF_N_MWSTKENNUNG = MwStId,
                LIEF_L_RUECKGABE = Rueckgaberecht,
                LIEF_N_RUECKGABE_TAGE = RueckgaberechtTage,
                LIEF_L_SPERRE = Gesperrt,
                LIEF_A_SELEKTION1 = Selektionsmerkmal1,
                LIEF_A_SELEKTION2 = Selektionsmerkmal2,
                LIEF_A_SELEKTION3 = Selektionsmerkmal3,
                LIEF_L_BONUS = Bonus,
                LIEF_N_BONUS1PROZ = Bonus1Prozent,
                LIEF_N_BONUS1WERT = Bonus1Wert,
                LIEF_N_BONUS2PROZ = Bonus2Prozent,
                LIEF_N_BONUS2WERT = Bonus2Wert,
                LIEF_N_BONUS3PROZ = Bonus3Prozent,
                LIEF_N_BONUS3WERT = Bonus3Wert,
                LIEF_N_NR = Lieferantennummer,
                LIEF_WK5_N_RUECK_ADRESSE = RuecklieferAdressId,
                LIEF_WK5_N_VERPACKKOSTEN = Verpackungskosten,
                LIEF_WK5_N_VERSANDKOSTEN = Versandkosten,
                LIEF_WK5_N_VERSICHERKOSTEN = Versicherungskosten,
                LIEF_WK5_L_DIREKT_ERLAUBT = DirektLieferungErlaubt,
                LIEF_WK5_B_SHOPPASSWORT = ShopPasswort,
                LIEF_WK5_B_SHOPUSERNAME = ShopUsername,
                LIEF_WK5_L_AUTOIMPORT = Autoimport,
                Mindermengenzuschlag = Mindermengenzuschlag,
                LIEF_A_PARTNER = Partner,
                LIEF_A_WARNHINWEISE = Warnhinweise,
                LIEF_L_EIGENLIEFERANT = Eigenlieferant
            };
        }

        public async Task<VatCheck> PrüfeUstIdAsync(VatService vatService)
        {

            VatRequest vatRequest = new VatRequest
            (
                UstId ?? String.Empty,
                Name1 ?? String.Empty,
                Ort ?? String.Empty,
                Postleitzahl ?? String.Empty,
                Strasse ?? String.Empty,
                "Keine Kundennummer",
                false,
                VatZuordnung.Lieferant,
                0
            );
            using FbController2 fbController = new FbController2();
            var vatResult = await vatService.CheckVatAsync(vatRequest, fbController, false);
            return vatResult;
        }


        public LieferantenInput(int lieferantennummer = 0)
        {
            Lieferantennummer = lieferantennummer;
            ChartFrom = DateTime.Now.Year - 3;
            ChartTo = DateTime.Now.Year;
        }
    }
}
