﻿using KarleyLibrary.Attributes;
using System.ComponentModel.DataAnnotations;
using WK5.Core.Models;

namespace WK5.Core.PageModels.Stammdaten.Lieferanten
{
    public class LieferantenAnschriftInput
    {
        public int Nummer { get; } = -1;
        public int Lieferantennummer { get; set; }
        public string? Name1 { get; set; }
        public string? Name2 { get; set; }
        public string? Name3 { get; set; }
        public string? Ansprechpartner { get; set; }
        public string? Strasse { get; set; }
        public string? Land { get; set; }
        public string? Postleitzahl { get; set; }
        public string? Ort { get; set; }
        public string? Telefon { get; set; }
        public string? Fax { get; set; }
        public string? Email { get; set; }
        public string? IBAN { get; set; }
        public string? BIC { get; set; }
        public string? Bankname { get; set; }
        public string? Kontoinhaber { get; set; }
        public string? AdressFunktion { get; set; }


        public LieferantenAnschriftInput()
        {

        }
        public LieferantenAnschriftInput(int nummer)
        {
            this.Nummer = nummer;
        }

        public LieferantenAnschrift ToLieferantenRechnungsAnschrift()
        {
            return new LieferantenAnschrift
            {
                LIRE_N_LIEFNR = Lieferantennummer,
                LIRE_N_NR = Nummer,
                LIRE_A_NAME1 = Name1,
                LIRE_A_NAME2 = Name2,
                LIRE_A_NAME3 = Name3,
                LIRE_A_STRASSE = Strasse,
                LIRE_A_LAND = Land,
                LIRE_A_PLZ = Postleitzahl,
                LIRE_A_ORT = Ort,
                LIRE_A_TEL = Telefon,
                LIRE_A_FAX = Fax,
                LIRE_A_EMAIL = Email,
                LIRE_A_PARTNER = Ansprechpartner,
                LIRE_A_IBAN = IBAN,
                LIRE_A_BIC = BIC,
                LIRE_A_BANKNAME = Bankname,
                LIRE_A_KONTOINHABER = Kontoinhaber,
                LIRE_WK5_A_FUNKTION = AdressFunktion
            };
        }
    }
}
