﻿using KarleyLibrary.Attributes;
using KarleyLibrary.Erweiterungen;
using System;
using System.ComponentModel.DataAnnotations;
using System.Text;
using WK5.Core.Models;

namespace WK5.Core.PageModels.Stammdaten.Kunden
{
    public class RechnungsanschriftInput
    {
        private string? _notiz;

        public string? Kundennummer { get; set; }
        public bool WirdVerwendet { get; }
        /// <summary>
        /// Ruft die ID der Rechnungsanschrift ab.
        /// <para>
        /// Der default Wert ist -1, da es in der W4 auch Rechnungsanschriften mit der ID 0 gibt. Anhand der ID lässt sich also erkennen, ob eine Rechnungsanschrift neu angelegt werden muss, oder nicht. Die ID wird automatisch durch die Anlage vergeben.
        /// </para>
        /// </summary>
        public int Nummer { get; } = -1;
        public string Firma { get; set; } = String.Empty;
        public string? Name2 { get; set; }
        public string? Name3 { get; set; }
        public string? Straße { get; set; }
        public string Land { get; set; } = "DE";
        public string? Postleitzahl { get; set; }
        public string? Ort { get; set; }
        public string? Telefon { get; set; }
        public string? Fax { get; set; }
        public string? Email { get; set; }
        public string? Partner { get; set; }

        public bool Hauptanschrift { get; set; }
        public string? Notiz
        {
            get
            {
                if (_notiz is null)
                {
                    return null;
                }

                return StringErweiterung.ConvertEncoding(_notiz, Encoding.GetEncoding("ISO-8859-1"), Encoding.UTF8);
            }
            set
            {
                if (value is null)
                {
                    _notiz = null;
                    return;
                }

                _notiz = StringErweiterung.ConvertEncoding(value, Encoding.UTF8, Encoding.GetEncoding("ISO-8859-1"));
            }
        }
        public RechnungsanschriftInput()
        {

        }
        public RechnungsanschriftInput(int nummer, bool wirdVerwendet = false)
        {
            this.Nummer = nummer;
            this.WirdVerwendet = wirdVerwendet;
        }

        public Rechnungsanschrift ToRechnungsanschrift()
        {
            return new Rechnungsanschrift
            {
                KURE_N_NR = Nummer,
                KURE_A_KUNDNR = Kundennummer,
                KURE_A_EMAIL = Email,
                KURE_A_LAND = Land,
                KURE_A_FAX = Fax,
                KURE_A_NAME1 = Firma,
                KURE_A_NAME2 = Name2,
                KURE_A_NAME3 = Name3,
                KURE_A_ORT = Ort,
                KURE_A_PLZ = Postleitzahl,
                KURE_A_TEL = Telefon,
                KURE_A_STRASSE = Straße,
                KURE_A_PARTNER = Partner,
                KURE_WK5_L_HAUPTANSCHRIFT = Hauptanschrift,
                KURE_WK5_A_NOTIZ = Notiz
            };
        }
    }
}
