﻿using KarleyLibrary.Attributes;
using KarleyLibrary.Erweiterungen;
using System;
using System.ComponentModel.DataAnnotations;
using System.Text;
using WK5.Core.Models;

namespace WK5.Core.PageModels.Stammdaten.Kunden
{
    public class LieferanschriftInput
    {
        private string? _notiz;
        private string _ort = String.Empty;
        private string _postleitzahl = String.Empty;
        private string _land = "DE";
        private string _straße = String.Empty;
        private string _name2 = String.Empty;

        public string? Kundennummer { get; set; }
        public bool WirdVerwendet { get; }
        /// <summary>
        /// Ruft die ID der Lieferanschrift ab.
        /// <para>
        /// Der default Wert ist -1, da es in der W4 auch Lieferanschriften mit der ID 0 gibt. Anhand der ID lässt sich also erkennen, ob eine Lieferanschrift neu angelegt werden muss, oder nicht. Die ID wird automatisch durch die Anlage vergeben.
        /// </para>
        /// </summary>
        public int Nummer { get; } = -1;
        public string Firma { get; set; } = String.Empty;
        public string Name2 { get => _name2; set => _name2 = value ?? String.Empty; }
        public string? Name3 { get; set; }
        public string Straße { get => _straße; set => _straße = value ?? String.Empty; }
        public string Land { get => _land; set => _land = value ?? "DE"; }
        public string Postleitzahl { get => _postleitzahl; set => _postleitzahl = value ?? String.Empty; }
        public string Ort { get => _ort; set => _ort = value ?? String.Empty; }
        public string? Telefon { get; set; }
        public string? Fax { get; set; }
        public string? Email { get; set; }
        public string? Partner { get; set; }

        public bool Hauptanschrift { get; set; }
        public string? Notiz
        {
            get
            {
                if (_notiz is null)
                {
                    return null;
                }

                return StringErweiterung.ConvertEncoding(_notiz, Encoding.GetEncoding("ISO-8859-1"), Encoding.UTF8);
            }
            set
            {
                if (value is null)
                {
                    _notiz = null;
                    return;
                }

                _notiz = StringErweiterung.ConvertEncoding(value, Encoding.UTF8, Encoding.GetEncoding("ISO-8859-1"));
            }
        }
        public LieferanschriftInput()
        {

        }
        public LieferanschriftInput(int nummer, bool wirdVerwendet = false)
        {
            this.Nummer = nummer;
            this.WirdVerwendet = wirdVerwendet;
        }

        public Lieferanschrift ToLieferanschrift()
        {
            return new Lieferanschrift
            {
                KULA_N_NR = Nummer,
                KULA_A_KUNDNR = Kundennummer,
                KULA_A_EMAIL = Email,
                KULA_A_FAX = Fax,
                KULA_A_LAND = Land,
                KULA_A_NAME1 = Firma,
                KULA_A_NAME2 = Name2,
                KULA_A_NAME3 = Name3,
                KULA_A_ORT = Ort,
                KULA_A_PLZ = Postleitzahl,
                KULA_A_STRASSE = Straße,
                KULA_A_TEL = Telefon,
                KULA_A_PARTNER = Partner,
                KULA_WK5_L_HAUPTANSCHRIFT = Hauptanschrift,
                KULA_WK5_A_NOTIZ = Notiz
            };
        }

        

    }
}
