﻿using System;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Models;

namespace WK5.Core.PageModels.Stammdaten.Kunden
{
    public class KundenrabattInput
    {
        private decimal _preis;
        private decimal _rabatt1;
        private decimal _staffelPreis1;
        private decimal _staffelPreis2;
        private decimal _staffelPreis3;
        private decimal _staffelPreis4;
        private decimal _staffelRabatt1;
        private decimal _staffelRabatt2;
        private decimal _staffelRabatt3;
        private decimal _staffelRabatt4;

        public string Bezeichnung { get; }
        public bool IstNeu { get; set; }
        public string Kundennummer { get; set; } = String.Empty;
        public string Artikelnummer { get; set; } = String.Empty;
        public string? Kundenartikelnummer { get; set; }
        public decimal StaffelPreis1
        {
            get => _staffelPreis1;
            set
            {
                _staffelPreis1 = value;

                if (_staffelPreis1 is 0)
                {
                    _staffelRabatt1 = 0;
                }
                else
                {
                    _staffelRabatt1 = MathExtensions.BerechneProzent(_staffelPreis1, Artikelpreis);
                }
            }
        }
        public decimal StaffelPreis2
        {
            get => _staffelPreis2;
            set
            {
                _staffelPreis2 = value;
                if (_staffelPreis2 is 0)
                {
                    _staffelRabatt2 = 0;
                }
                else
                {
                    _staffelRabatt2 = MathExtensions.BerechneProzent(_staffelPreis2, Artikelpreis);
                }
            }
        }
        public decimal StaffelPreis3
        {
            get => _staffelPreis3;
            set
            {
                _staffelPreis3 = value;
                if (_staffelPreis3 is 0)
                {
                    _staffelRabatt3 = 0;
                }
                else
                {
                    _staffelRabatt3 = MathExtensions.BerechneProzent(_staffelPreis3, Artikelpreis);
                }
            }
        }
        public decimal StaffelPreis4
        {
            get => _staffelPreis4;
            set
            {
                _staffelPreis4 = value;
                if (_staffelPreis4 is 0)
                {
                    _staffelRabatt4 = 0;
                }
                else
                {
                    _staffelRabatt4 = MathExtensions.BerechneProzent(_staffelPreis4, Artikelpreis);
                }
            }
        }
        public decimal StaffelMenge1 { get; set; }
        public decimal StaffelMenge2 { get; set; }
        public decimal StaffelMenge3 { get; set; }
        public decimal StaffelMenge4 { get; set; }

        public decimal StaffelRabatt1
        {
            get => _staffelRabatt1;
            set
            {
                _staffelRabatt1 = value;

                if (_staffelRabatt1 is 0)
                {
                    _staffelPreis1 = 0;
                }
                else
                {
                    _staffelPreis1 = MathExtensions.BerechnePreis(Artikelpreis, _staffelRabatt1);
                }
            }
        }
        public decimal StaffelRabatt2
        {
            get => _staffelRabatt2;
            set
            {
                _staffelRabatt2 = value;

                if (_staffelRabatt2 is 0)
                {
                    _staffelPreis2 = 0;
                }
                else
                {
                    _staffelPreis2 = MathExtensions.BerechnePreis(Artikelpreis, _staffelRabatt2);
                }
            }
        }
        public decimal StaffelRabatt3
        {
            get => _staffelRabatt3;
            set
            {
                _staffelRabatt3 = value;
                if (_staffelRabatt3 is 0)
                {
                    _staffelPreis3 = 0;
                }
                else
                {
                    _staffelPreis3 = MathExtensions.BerechnePreis(Artikelpreis, _staffelRabatt3);
                }
            }
        }
        public decimal StaffelRabatt4
        {
            get => _staffelRabatt4;
            set
            {
                _staffelRabatt4 = value;
                if (_staffelRabatt4 is 0)
                {
                    _staffelPreis4 = 0;
                }
                else
                {
                    _staffelPreis4 = MathExtensions.BerechnePreis(Artikelpreis, _staffelRabatt4);
                }
            }
        }


        public decimal Preis
        {
            get => _preis;
            set
            {
                _preis = value;
                if (_preis is 0)
                {
                    _rabatt1 = 0;
                }
                else
                {
                    _rabatt1 = MathExtensions.BerechneProzent(_preis, Artikelpreis);
                }

            }
        }
        public decimal Rabatt1
        {
            get => _rabatt1;
            set
            {
                _rabatt1 = value;
                if (_rabatt1 is 0)
                {
                    _preis = 0;
                }
                else
                {
                    _preis = MathExtensions.BerechnePreis(Artikelpreis, Rabatt1);
                }
            }
        }

        public StaffelpreisCollection Staffelpreise { get; set; } = new StaffelpreisCollection(4);

        public bool ZeitlichBegrenzen { get; set; }
        public DateTime GültigBis { get; set; } = DateTime.Now.AddDays(7);

        public decimal Artikelpreis { get; set; }


        public KundenrabattInput(bool neu, string bezeichnung)
        {
            IstNeu = neu;
            Bezeichnung = bezeichnung;
        }

        public void SortStaffelpreise()
        {
            Staffelpreise.Clean();
            Staffelpreise.Sort();
            for (int i = 0; i < Staffelpreise.MaxAnzahl; i++)
            {
                Staffelpreis? preis = Staffelpreise.Get(i);
                switch (i)
                {
                    case 0:
                        {
                            StaffelPreis1 = StaffelPreis1;
                            StaffelMenge1 = preis?.Menge ?? 0;
                            StaffelRabatt1 = preis?.Rabatt ?? 0;
                        }
                        break;
                    case 1:
                        {
                            StaffelPreis2 = StaffelPreis1;
                            StaffelMenge2 = preis?.Menge ?? 0;
                            StaffelRabatt2 = preis?.Rabatt ?? 0;
                        }
                        break;
                    case 2:
                        {
                            StaffelPreis3 = StaffelPreis1;
                            StaffelMenge3 = preis?.Menge ?? 0;
                            StaffelRabatt3 = preis?.Rabatt ?? 0;
                        }
                        break;
                    case 3:
                        {
                            StaffelPreis4 = StaffelPreis1;
                            StaffelMenge4 = preis?.Menge ?? 0;
                            StaffelRabatt4 = preis?.Rabatt ?? 0;
                        }
                        break;
                    default:
                        break;
                }
            }
        }

    }
}
