﻿using KarleyLibrary.Attributes;
using KarleyLibrary.Erweiterungen;
using System;
using System.ComponentModel.DataAnnotations;
using System.Text;
using WK5.Core.Models;

namespace WK5.Core.PageModels.Stammdaten.Kunden
{
    public class AnsprechpartnerInput
    {

        private string? _notiz;
        public string? Kundennummer { get; set; }

        /// <summary>
        /// Ruft die ID des Ansprechpartners ab.
        /// <para>
        /// Der default Wert ist -1, da es in der W4 auch Ansprechpartner mit der ID 0 gibt. Anhand der ID lässt sich also erkennen, ob ein Ansprechpartner neu angelegt werden muss, oder nicht. Die ID wird automatisch durch die Anlage vergeben.
        /// </para>
        /// </summary>
        public int Nummer { get; set; } = -1;
        public string Vorname { get; set; } = String.Empty;
        public string Nachname { get; set; } = String.Empty;
        public string? Bereich { get; set; }
        public string Anrede { get; set; } = String.Empty;

        public string? Telefon { get; set; }
        public string? Mobil { get; set; }
        public string? Fax { get; set; }
        public string Email { get; set; } = String.Empty;

        public bool Hauptansprechpartner { get; set; }
        public string? Notiz
        {
            get
            {
                if (_notiz is null)
                {
                    return null;
                }

                return StringErweiterung.ConvertEncoding(_notiz, Encoding.GetEncoding("ISO-8859-1"), Encoding.UTF8);
            }
            set
            {
                if (value is null)
                {
                    _notiz = null;
                    return;
                }

                _notiz = StringErweiterung.ConvertEncoding(value, Encoding.UTF8, Encoding.GetEncoding("ISO-8859-1"));
            }
        }
        public int Funktion { get; set; }
        public AnsprechpartnerInput()
        {

        }
        public AnsprechpartnerInput(int nummer)
        {
            this.Nummer = nummer;
        }

        public Ansprechpartner ToAnsprechpartner()
        {
            return new Ansprechpartner
            {
                PART_A_KUNDNR = Kundennummer ?? String.Empty,
                PART_N_NR = Nummer,
                PART_A_VORNAME = Vorname,
                PART_A_NAME = Nachname,
                PART_A_BEREICH = Bereich,
                PART_A_BRIEFANREDE = Anrede,
                PART_A_TELEFON = Telefon,
                PART_A_MOBIL = Mobil,
                PART_A_EMAIL = Email,
                PART_A_TELEFAX = Fax,
                PART_WK5_L_HAUPT = Hauptansprechpartner,
                PART_WK5_A_NOTIZ = Notiz,
                PART_N_FUNKTION = Funktion
            };
        }
    }
}
