using KarleyLibrary.Attributes;
using System;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Threading.Tasks;
using WK5.Core.Basis.Erweiterungen;
using WK5.Core.Models;

namespace WK5.Core.PageModels.Stammdaten.Artikeldaten
{
    public class LieferantenArtikelInput
    {
        private decimal _staffelPreis1;
        private decimal _staffelPreis2;
        private decimal _staffelPreis3;
        private decimal _staffelPreis4;
        private decimal _staffelRabatt1;
        private decimal _staffelRabatt2;
        private decimal _staffelRabatt3;
        private decimal _staffelRabatt4;
        private decimal _preis;
        private int _mindestabnahme = 1;

        [Iso88591]
        [MaxLength(30)]
        public string Artikelnummer { get; }
        [Required]
        public int Lieferantennummer { get; set; }
        [Required]
        [Iso88591]
        [MaxLength(30)]
        public string? Bestellnummer { get; set; }
        [Required]
        public decimal Preis
        {
            get => _preis; set
            {
                _preis = value;
                Staffelpreise.SetBezugspreis(_preis);
            }
        }
        public decimal Rabatt { get; set; }
        public DateTime LetzteÄnderung { get; set; }
        public bool Hauptlieferant { get; set; }
        public int Mindestabnahme { get => _mindestabnahme <= 0 ? 1 : _mindestabnahme; set => _mindestabnahme = (value <= 0 ? 1 : value); }
        public decimal Rabatt2 { get; set; }
        public decimal Versandkosten { get; set; }
        public decimal Verpackungskosten { get; set; }
        public decimal Teuerung { get; set; }
        public decimal Sonstiges { get; set; }
        [Iso88591]
        [MaxLength(5)]
        public string? Währung { get; set; }
        public decimal Kurs { get; set; }
        public decimal PreisWährung { get; set; }

        [Iso88591]
        public string? Notiz { get; set; }
        [Required]
        [Iso88591]
        [MaxLength(60)]
        public string? Beschreibung1 { get; set; } = String.Empty;
        [Iso88591]
        [MaxLength(60)]
        public string? Beschreibung2 { get; set; }
        [Iso88591]
        [MaxLength(60)]
        public string? Beschreibung3 { get; set; }
        [Iso88591]
        [MaxLength(60)]
        public string? Beschreibung4 { get; set; }
        [Iso88591]
        [MaxLength(60)]
        public string? Beschreibung5 { get; set; }

        public decimal StaffelPreis1
        {
            get => _staffelPreis1;
            set
            {
                _staffelPreis1 = value;

                if (_staffelPreis1 is 0)
                {
                    _staffelRabatt1 = 0;
                }
                else
                {
                    _staffelRabatt1 = MathExtensions.BerechneProzent(_staffelPreis1, Preis);
                }
            }
        }
        public decimal StaffelPreis2
        {
            get => _staffelPreis2;
            set
            {
                _staffelPreis2 = value;

                if (_staffelPreis2 is 0)
                {
                    _staffelRabatt2 = 0;
                }
                else
                {
                    _staffelRabatt2 = MathExtensions.BerechneProzent(_staffelPreis2, Preis);
                }
            }
        }
        public decimal StaffelPreis3
        {
            get => _staffelPreis3;
            set
            {
                _staffelPreis3 = value;
                if (_staffelPreis3 is 0)
                {
                    _staffelRabatt3 = 0;
                }
                else
                {
                    _staffelRabatt3 = MathExtensions.BerechneProzent(_staffelPreis3, Preis);
                }
            }
        }
        public decimal StaffelPreis4
        {
            get => _staffelPreis4;
            set
            {
                _staffelPreis4 = value;
                if (_staffelPreis4 is 0)
                {
                    _staffelRabatt4 = 0;
                }
                else
                {
                    _staffelRabatt4 = MathExtensions.BerechneProzent(_staffelPreis4, Preis);
                }
            }
        }
        public decimal Staffelmenge1 { get; set; }
        public decimal Staffelmenge2 { get; set; }
        public decimal Staffelmenge3 { get; set; }
        public decimal Staffelmenge4 { get; set; }
        public decimal StaffelRabatt1
        {
            get => _staffelRabatt1;
            set
            {
                _staffelRabatt1 = value;
                if (_staffelRabatt1 is 0)
                {
                    _staffelPreis1 = 0;
                }
                else
                {
                    _staffelPreis1 = MathExtensions.BerechnePreis(Preis, _staffelRabatt1);
                }
            }
        }
        public decimal StaffelRabatt2
        {
            get => _staffelRabatt2;
            set
            {
                _staffelRabatt2 = value;
                if (_staffelRabatt2 is 0)
                {
                    _staffelPreis2 = 0;
                }
                else
                {
                    _staffelPreis2 = MathExtensions.BerechnePreis(Preis, _staffelRabatt2);
                }
            }
        }
        public decimal StaffelRabatt3
        {
            get => _staffelRabatt3;
            set
            {
                _staffelRabatt3 = value;
                if (_staffelRabatt3 is 0)
                {
                    _staffelPreis3 = 0;
                }
                else
                {
                    _staffelPreis3 = MathExtensions.BerechnePreis(Preis, _staffelRabatt3);
                }
            }
        }
        public decimal StaffelRabatt4
        {
            get => _staffelRabatt4;
            set
            {
                _staffelRabatt4 = value;
                if (_staffelRabatt4 is 0)
                {
                    _staffelPreis4 = 0;
                }
                else
                {
                    _staffelPreis4 = MathExtensions.BerechnePreis(Preis, _staffelRabatt4);
                }
            }
        }

        public StaffelpreisCollection Staffelpreise { get; set; } = new StaffelpreisCollection(4);




        public decimal Lieferantenbestand { get; set; }

        public Lieferant? Lieferant { get; set; }

        public LieferantenArtikelInput(string artikelnummer)
        {
            Artikelnummer = artikelnummer;
        }

        public Lieferantenartikel ToLieferantenartikel()
        {
            Staffelpreise.Clean();
            Staffelpreise.Sort();
            for (int i = 0; i < Staffelpreise.MaxAnzahl; i++)
            {
                Staffelpreis? preis = Staffelpreise.Get(i);
                switch (i)
                {
                    case 0:
                        {
                            StaffelPreis1 = Preis;
                            Staffelmenge1 = preis?.Menge ?? 0;
                            StaffelRabatt1 = preis?.Rabatt ?? 0;
                        }
                        break;
                    case 1:
                        {
                            StaffelPreis2 = Preis;
                            Staffelmenge2 = preis?.Menge ?? 0;
                            StaffelRabatt2 = preis?.Rabatt ?? 0;
                        }
                        break;
                    case 2:
                        {
                            StaffelPreis3 = Preis;
                            Staffelmenge3 = preis?.Menge ?? 0;
                            StaffelRabatt3 = preis?.Rabatt ?? 0;
                        }
                        break;
                    case 3:
                        {
                            StaffelPreis4 = Preis;
                            Staffelmenge4 = preis?.Menge ?? 0;
                            StaffelRabatt4 = preis?.Rabatt ?? 0;
                        }
                        break;
                    default:
                        break;
                }
            }


            return new Lieferantenartikel()
            {
                ARLI_A_ARTIKELNR = Artikelnummer,
                ARLI_A_BESTELLNR = Bestellnummer,
                ARLI_A_BEZ1 = Beschreibung1,
                ARLI_A_BEZ2 = Beschreibung2,
                ARLI_A_BEZ3 = Beschreibung3,
                ARLI_A_BEZ4 = Beschreibung4,
                ARLI_A_BEZ5 = Beschreibung5,
                ARLI_A_WAEHRUNG = Währung,
                ARLI_B_NOTIZ = Notiz,
                ARLI_D_LETZAEND = LetzteÄnderung,
                ARLI_L_HAUPTLIEFERANT = Hauptlieferant,
                ARLI_N_KURS = Kurs,
                ARLI_N_LIEFNR = Lieferantennummer,
                ARLI_N_MENGE1 = Staffelmenge1,
                ARLI_N_MENGE2 = Staffelmenge2,
                ARLI_N_MENGE3 = Staffelmenge3,
                ARLI_N_MENGE4 = Staffelmenge4,
                ARLI_N_PREISMENGE1 = StaffelPreis1,
                ARLI_N_PREISMENGE2 = StaffelPreis2,
                ARLI_N_PREISMENGE3 = StaffelPreis3,
                ARLI_N_PREISMENGE4 = StaffelPreis4,
                ARLI_N_RABATTMENGE1 = StaffelRabatt1,
                ARLI_N_RABATTMENGE2 = StaffelRabatt2,
                ARLI_N_RABATTMENGE3 = StaffelRabatt3,
                ARLI_N_RABATTMENGE4 = StaffelRabatt4,
                ARLI_N_MINDESTABNAHME = Mindestabnahme,
                ARLI_N_RABATT = Rabatt,
                ARLI_N_RABATT2 = Rabatt2,
                ARLI_N_PREIS = Preis,
                ARLI_N_SONSTKOST = Sonstiges,
                ARLI_N_TEUERUNG = Teuerung,
                ARLI_N_VERPACKKOST = Verpackungskosten,
                ARLI_N_VERSANDKOST = Versandkosten,
                WK5_ARLI_N_LIEFBESTAND = Lieferantenbestand,
                ARLI_N_WAEHRUNGSPREIS = PreisWährung,


            };


        }


        public async Task RecalculatePreise()
        {
            Währung? wFremd = await WK5.Core.Models.Währung.GetWährungAsync(Währung);

            if (wFremd is null)
            {
                throw new ArgumentNullException("Es wurde keine Währung angegeben. Bitte an die Programmierung wenden!");
            }

            Preis = PreisWährung * wFremd.WAEH_N_WECHSELKURS;
            Kurs = wFremd.WAEH_N_WECHSELKURS;

            Währung = wFremd.WAEH_A_ZEICHEN;

        }
    }
}
