﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using WK5.Core;
using WK5.Core.Models.Lager;
using WK5.Core.Models.Versand;

namespace WK5.Core.PageModels.Lagerregal
{
    public sealed class VersandBelegInput
    {
        public event EventHandler? BelegChanged;

        private void OnBelegChanged(object sender, EventArgs e)
        {
            BelegChanged?.Invoke(sender, e);
        }

        private BelegTyp _belegTyp;
        private int _belegnummer;
        public BelegTyp BelegTyp
        {
            get => _belegTyp;
            set
            {
                _belegTyp = value;
                OnBelegChanged(this, EventArgs.Empty);
            }
        }
        [Required]
        [Range(10000, Int32.MaxValue)]
        public int Belegnummer
        {
            get => _belegnummer;
            set
            {
                _belegnummer = value;
                OnBelegChanged(this, EventArgs.Empty);
            }
        }



        public CourierArt CourierArt { get; set; } = CourierArt.UST;

        [ValidateComplexType]
        public List<PaketInput> Pakete { get; } = new List<PaketInput>();

        public int AnzahlPakete { get; private set; } = 0;

        public bool MailSenden { get; set; } = true;

        public VersandBelegInput()
        {
            AddPaket();
        }

        public void AddPaket(decimal gewicht = 0)
        {
            Pakete.Add(new PaketInput { Paketnummer = ++AnzahlPakete, Gewicht = gewicht });
        }

        public void RemovePaket()
        {
            Pakete.RemoveAt(--AnzahlPakete);
        }



    }

}
