﻿using KarleyLibrary.Erweiterungen;
using System;
using System.ComponentModel.DataAnnotations;
using System.Text;
using WK5.Core.Models.Inventuren;

namespace WK5.Core.PageModels.Inventuren
{
    public class InventurManuellBuchenInput
    {
        private string kommentar = String.Empty;

        public InventurArtikel Artikel { get; }
        [Required]
        [Range(0.1, 100000)]
        public decimal Menge { get; set; } = 1;
        [Required]
        public string Lagerregal { get; set; } = String.Empty;
        public string Kommentar { get => kommentar; set => kommentar = StringErweiterung.ConvertEncoding(value, Encoding.UTF8, Encoding.GetEncoding("ISO-8859-1")); }

        public string Seriennummer { get; set; } = String.Empty;
        public InventurManuellBuchenInput(InventurArtikel artikel)
        {
            Artikel = artikel;
            Lagerregal = artikel.Lagerplatz;
        }
    }
}
