﻿using KarleyLibrary.Attributes;
using KarleyLibrary.Erweiterungen;
using System;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace WK5.Core.PageModels.Inventuren
{
    public class InventurBuchungInput
    {
        private string kommentar = String.Empty;

        [Required(AllowEmptyStrings = false, ErrorMessage = "Bitte geben Sie eine Artikelnummer ein")]
        [MaxLength(30, ErrorMessage = "Die Artikelnummer darf nicht länger als 30 Zeichen sein.")]
        [Iso88591]
        public string Artikelnummer { get; set; } = String.Empty;
        public string Kommentar { get => kommentar; set => kommentar = StringErweiterung.ConvertEncoding(value, Encoding.UTF8, Encoding.GetEncoding("ISO-8859-1")); }

        public string Seriennummer { get; set; } = String.Empty;
    }
}
