﻿namespace WK5.Core.PageModels
{
    /// <summary>
    /// Stellt Eigenschaften und Methoden zum einbinden einer auf Enum basiereten Navigation zur Verfügung.
    /// </summary>
    /// <typeparam name="T"></typeparam>
    public interface ITabView<T> where T : System.Enum
    {
        /// <summary>
        /// Ruft den derzeit aktiven Tab ab, oder legt diesen fest.
        /// </summary>
        T ActiveTab { get; set; }
        /// <summary>
        /// Generiert die CSS-Klasse für das Highlighting des aktiven Navigations-Element.
        /// </summary>
        string GetNavListClass(bool isActive);
        /// <summary>
        /// Generiert die CSS-Klasse für das Highlighting des aktiv ausgewählten Tabpanes.
        /// </summary>
        string GetTabClass(bool isActive);
    }
}
