﻿using System;
using System.ComponentModel.DataAnnotations;

namespace WK5.Core.PageModels.Einkauf.Bestellungen
{
    public class BestellungPrüfenInput
    {
        [Required]
        public int Bestellnummer { get; set; }
        [Required]
        public string Auftragsbestätigungsnummer { get; set; } = String.Empty;
        [Required]
        public DateTime Liefertermin { get; set; }

        [Range(0, int.MaxValue)]
        public decimal Frachtkosten { get; set; }
        [Range(0, int.MaxValue)]
        public decimal Verpackungskosten { get; set; }
        [Range(0, int.MaxValue)]
        public decimal Versicherungskosten { get; set; }
        [Range(0, int.MaxValue)]
        public decimal Mindermengenzuschlag { get; set; }

    }
}
