﻿using KarleyLibrary.Attributes;
using KarleyLibrary.Erweiterungen;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.OpenCart
{
    public class ProductFilter
    {
        [CompareField("product_id")]
        public int ProductId { get; set; }
        [CompareField("filter_id")]
        public int FilterId { get; set; }

        internal string GetUpdateProperties(MySqlController2? mySqlController = null)
        {
            StringBuilder sb = new StringBuilder();
            sb.AppendLine("product_id = @product_id,");
            sb.AppendLine("filter_id = @filter_id");

            if(mySqlController is not null)
            {
                mySqlController.AddParameter("@product_id", ProductId);
                mySqlController.AddParameter("@filter_id", FilterId);
            }            

            return sb.ToString();
        }

        public static async IAsyncEnumerable<ProductFilter> FromProductAsync(int product_id, string connectionString)
        {
            using MySqlController2 mySqlController = new MySqlController2(connectionString);

            mySqlController.AddParameter("@product_id", product_id);
            DataTable data = await mySqlController.SelectDataAsync("SELECT * FROM `product_filter` WHERE product_id = @product_id");

            foreach(DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new ProductFilter(), row);
            }
        }

        public static async IAsyncEnumerable<ProductFilter> FromFilterAsync(int filter_id, string connectionString)
        {
            using MySqlController2 mySqlController = new MySqlController2(connectionString);

            mySqlController.AddParameter("@filter_id", filter_id);
            DataTable data = await mySqlController.SelectDataAsync("SELECT * FROM `product_filter` WHERE filter_id = @filter_id");

            foreach (DataRow row in data.Rows)
            {
                yield return ObjectErweiterung.DataRowZuObjekt(new ProductFilter(), row);
            }
        }

        public async Task AddFilterAsync(string connectionString)
        {
            using MySqlController2 mySqlController = new MySqlController2(connectionString);

            mySqlController.AddParameter("@product_id", ProductId);
            mySqlController.AddParameter("@filter_id", FilterId);
            await mySqlController.QueryAsync(@"INSERT INTO `product_filter` (product_id,filter_id) VALUES (@product_id, @filter_id)");
        }

        public async Task UpdateFilterAsync(string connectionString)
        {
            using MySqlController2 mySqlController = new MySqlController2(connectionString);

            mySqlController.AddParameter("@product_id", ProductId);
            mySqlController.AddParameter("@filter_id", FilterId);
            await mySqlController.QueryAsync(@"UPDATE `product_filter` SET product_id = @product_id, filter_id = @filter_id WHERE product_id = @product_id AND filter_id = @filter_id");
        }

        public async Task DeleteFilterAsync(string connectionString)
        {
            using MySqlController2 mySqlController = new MySqlController2(connectionString);

            mySqlController.AddParameter("@product_id", ProductId);
            mySqlController.AddParameter("@filter_id", FilterId);
            await mySqlController.QueryAsync(@"DELETE FROM `product_filter` WHERE product_id = @product_id AND filter_id = @filter_id");
        }
    }
}
