﻿using KarleyLibrary.Attributes;
using KarleyLibrary.Erweiterungen;
using System;
using System.Data;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.OpenCart
{
    public class ProductDiscount
    {
        [CompareField("product_discount_id")]
        public int ProductDiscountId { get; set; }
        [CompareField("product_id")]
        public int ProductId { get; set; }
        [CompareField("customer_group_id")]
        public int CustomerGroupId { get; set; }
        public int Quantity { get; set; }
        public int Priority { get; set; } = 1;
        public decimal Price { get; set; }
        [CompareField("date_start")]
        public DateTime? DateStart { get; set; } = null;
        [CompareField("date_end")]
        public DateTime? DateEnd { get; set; } = null;

        //public static async Task DeleteProductDiscountAsync(int product_id)
        //{
        //    string sql = "DELETE FROM product_discount WHERE product_id = @product_id";
        //    using MySqlController2 mySqlController = new MySqlController2();
        //    mySqlController.AddParameter("@product_id", product_id);

        //    await mySqlController.QueryAsync(sql);
        //}


        public static async Task DeleteDiscountsAsync(int product_id, string connectionString)
        {
            using MySqlController2 mySqlController = new MySqlController2(connectionString);

            mySqlController.AddParameter("@product_id", product_id);
            await mySqlController.QueryAsync("DELETE FROM `product_discount` WHERE product_id = @product_id");
        }

        internal string GetUpdateProperties(MySqlController2? mySqlController = null)
        {
            StringBuilder sb = new StringBuilder();
            sb.AppendLine("customer_group_id = @customer_group_id,");
            sb.AppendLine("quantity = @quantity,");
            sb.AppendLine("priority = @priority,");
            sb.AppendLine("price = @price,");
            sb.AppendLine("date_start = @date_start,");
            sb.AppendLine("date_end = @date_end,");

            if (mySqlController is not null)
            {
                mySqlController.AddParameter("@customer_group_id", CustomerGroupId);
                mySqlController.AddParameter("@quantity", Quantity);
                mySqlController.AddParameter("@priority", Priority);
                mySqlController.AddParameter("@price", Price);
                mySqlController.AddParameter("@date_start", DateStart);
                mySqlController.AddParameter("@date_end", DateEnd);

            }

            return sb.ToString();
        }

        internal static async Task<T?> GetDiscountAsync<T>(T product, int product_id, string connectionString) where T : ProductDiscount
        {
            using MySqlController2 mySqlController = new MySqlController2(connectionString);

            mySqlController.AddParameter("@product_id", product_id);
            DataRow? row = await mySqlController.SelectRowAsync("SELECT * FROM `product_discount` WHERE product_discount_id = @product_discount_id");
            return row == null ? null : ObjectErweiterung.DataRowZuObjekt<T>(product, row);
        }
    }
}
