﻿using KarleyLibrary.Attributes;
using KarleyLibrary.Erweiterungen;
using System;
using System.Data;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.OpenCart
{
    public class ProductDescription
    {
        private string _name = String.Empty;
        private string _tag = String.Empty;
        private string _metaTitle = String.Empty;
        private string _meta_description = String.Empty;
        private string _metaKeyword = String.Empty;
        #region Properties
        [CompareField("product_id")]
        public int ProductId { get; set; }
        [CompareField("language_id")]
        public int LanguageId { get; set; }
        public string Name { get => _name; set => _name = value ?? String.Empty; }
        public string? Description { get; set; }
        public string Tag { get => _tag; set => _tag = value ?? String.Empty; }
        [CompareField("meta_title")]
        public string MetaTitle { get => _metaTitle; set => _metaTitle = value ?? String.Empty; }
        [CompareField("meta_description")]
        public string MetaDescription { get => _meta_description; set => _meta_description = value ?? String.Empty; }
        [CompareField("meta_keyword")]
        public string MetaKeyword { get => _metaKeyword; set => _metaKeyword = value ?? String.Empty; }
        #endregion


        public static async Task<ProductDescription?> GetProductDescriptionAsync(int product_id, string connectionString)
        {
            using MySqlController2 controller = new MySqlController2(connectionString);


            controller.AddParameter("@PRODUCT_ID", product_id);
            var row = await controller.SelectRowAsync("SELECT * FROM `product_description` WHERE product_id = @PRODUCT_ID");
            return row == null ? null : ObjectErweiterung.DataRowZuObjekt(new ProductDescription(), row);
        }

        internal string GetUpdateProperties(MySqlController2? mySqlController = null)
        {
            StringBuilder sb = new StringBuilder();
            sb.AppendLine("language_id = @language_id,");
            sb.AppendLine("name = @name,");
            sb.AppendLine("description = @description,");
            sb.AppendLine("tag = @tag,");
            sb.AppendLine("meta_title = @meta_title,");
            sb.AppendLine("meta_description = @meta_description,");
            sb.AppendLine("meta_keyword = @meta_keyword,");

            if (mySqlController is not null)
            {
                mySqlController.AddParameter("@product_id", ProductId);
                mySqlController.AddParameter("@language_id", LanguageId);
                mySqlController.AddParameter("@name", Name);
                mySqlController.AddParameter("@description", Description);
                mySqlController.AddParameter("@tag", Tag);
                mySqlController.AddParameter("@meta_title", MetaTitle);
                mySqlController.AddParameter("@meta_description", MetaDescription);
                mySqlController.AddParameter("@meta_keyword", MetaKeyword);

            }

            return sb.ToString();
        }

        internal static async Task<T?> GetProductDescriptionAsync<T>(T product, int product_id, string connectionString) where T : ProductDescription
        {
            using MySqlController2 mySqlController = new MySqlController2(connectionString);

            mySqlController.AddParameter("@product_id", product_id);
            DataRow? row = await mySqlController.SelectRowAsync("SELECT * FROM `product_description` WHERE product_id = @product_id");
            return row == null ? null : ObjectErweiterung.DataRowZuObjekt<T>(product, row);
        }
    }
}
