﻿#if DEBUG
#define HappyShit
#endif

using KarleyLibrary.Attributes;
using KarleyLibrary.Erweiterungen;
using System;
using System.Data;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.OpenCart
{
    public class Order
    {
        private string _invoice_prefix = String.Empty;
        private string _store_name = String.Empty;
        private string _store_url = String.Empty;
        private string _firstname = String.Empty;
        private string _lastname = String.Empty;
        private string _email = String.Empty;
        private string _telephone = String.Empty;
        private string _fax = String.Empty;
        private string _customField = String.Empty;
        private string _paymentFirstname = String.Empty;
        private string _paymentLastname = String.Empty;
        private string _paymentCompany = String.Empty;
        private string _paymentAddress1 = String.Empty;
        private string _paymentAddress2 = String.Empty;
        private string _paymentCity = String.Empty;
        private string _paymentPostcode = String.Empty;
        private string _paymentCountry = String.Empty;
        private string _paymentZone = String.Empty;
        private string _paymentAddressFormat = String.Empty;
        private string _paymentCustomField = String.Empty;
        private string _paymentMethod = String.Empty;
        private string _paymentCode = String.Empty;
        private string _shippingFirstname = String.Empty;
        private string _shippingLastname = String.Empty;
        private string _shippingCompany = String.Empty;
        private string _shippingAddress1 = String.Empty;
        private string _shippingAddress2 = String.Empty;
        private string _shippingCity = String.Empty;
        private string _shippingPostcode = String.Empty;
        private string _shippingCountry = String.Empty;
        private string _shippingZone = String.Empty;
        private string _shippingAddressFormat = String.Empty;
        private string _shippingCustomField = String.Empty;
        private string _shippingMethod = String.Empty;
        private string _shippingCode = String.Empty;
        private string _comment = String.Empty;
        private string _tracking = String.Empty;
        private string _currencyCode = String.Empty;
        private string _iP = String.Empty;
        private string _forwardedIp = String.Empty;
        private string _userAgent = String.Empty;
        private string _acceptLanguage = String.Empty;
        #region DB Attribute
        [CompareField("order_id")]
        public int OrderId { get; set; }
        [CompareField("invoice_no")]
        public int InvoiceNo { get; set; }
        [CompareField("invoice_prefix")]
        public string InvoicePrefix { get => _invoice_prefix; set => _invoice_prefix = value ?? String.Empty; }
        [CompareField("store_id")]
        public int StoreId { get; set; }
        [CompareField("store_name")]
        public string StoreName { get => _store_name; set => _store_name = value ?? String.Empty; }
        [CompareField("store_url")]
        public string StoreUrl { get => _store_url; set => _store_url = value ?? String.Empty; }
        [CompareField("customer_id")]
        public int CustomerId { get; set; }
        [CompareField("customer_group_id")]
        public int CustomeGroupId { get; set; }
        public string Firstname { get => _firstname; set => _firstname = value ?? String.Empty; }
        public string Lastname { get => _lastname; set => _lastname = value ?? String.Empty; }
        public string Email { get => _email; set => _email = value ?? String.Empty; }
        public string Telephone { get => _telephone; set => _telephone = value ?? String.Empty; }
        public string Fax { get => _fax; set => _fax = value ?? String.Empty; }
        [CompareField("custom_field")]
        public string CustomField { get => _customField; set => _customField = value ?? String.Empty; }
        [CompareField("payment_firstname")]
        public string PaymentFirstname { get => _paymentFirstname; set => _paymentFirstname = value ?? String.Empty; }
        [CompareField("payment_lastname")]
        public string PaymentLastname { get => _paymentLastname; set => _paymentLastname = value ?? String.Empty; }
        [CompareField("payment_company")]
        public string PaymentCompany { get => _paymentCompany; set => _paymentCompany = value ?? String.Empty; }
        [CompareField("payment_address_1")]
        public string PaymentAddress1 { get => _paymentAddress1; set => _paymentAddress1 = value ?? String.Empty; }
        [CompareField("payment_address_2")]
        public string PaymentAddress2 { get => _paymentAddress2; set => _paymentAddress2 = value ?? String.Empty; }
        [CompareField("payment_city")]
        public string PaymentCity { get => _paymentCity; set => _paymentCity = value ?? String.Empty; }
        [CompareField("payment_postcode")]
        public string PaymentPostcode { get => _paymentPostcode; set => _paymentPostcode = value ?? String.Empty; }
        [CompareField("payment_country")]
        public string PaymentCountry { get => _paymentCountry; set => _paymentCountry = value ?? String.Empty; }
        [CompareField("payment_country_id")]
        public int PaymentCountryId { get; set; }
        [CompareField("payment_zone")]
        public string PaymentZone { get => _paymentZone; set => _paymentZone = value ?? String.Empty; }
        [CompareField("payment_zone_id")]
        public int PaymentZoneId { get; set; }
        [CompareField("payment_address_format")]
        public string PaymentAddressFormat { get => _paymentAddressFormat; set => _paymentAddressFormat = value ?? String.Empty; }
        [CompareField("payment_custom_field")]
        public string PaymentCustomField { get => _paymentCustomField; set => _paymentCustomField = value ?? String.Empty; }
        [CompareField("payment_method")]
        public string PaymentMethod { get => _paymentMethod; set => _paymentMethod = value ?? String.Empty; }
        [CompareField("payment_code")]
        public string PaymentCode { get => _paymentCode; set => _paymentCode = value ?? String.Empty; }
        [CompareField("shipping_firstname")]
        public string ShippingFirstname { get => _shippingFirstname; set => _shippingFirstname = value ?? String.Empty; }
        [CompareField("shipping_lastname")]
        public string ShippingLastname { get => _shippingLastname; set => _shippingLastname = value ?? String.Empty; }
        [CompareField("shipping_company")]
        public string ShippingCompany { get => _shippingCompany; set => _shippingCompany = value ?? String.Empty; }
        [CompareField("shipping_address_1")]
        public string ShippingAddress1 { get => _shippingAddress1; set => _shippingAddress1 = value ?? String.Empty; }
        [CompareField("shipping_address_2")]
        public string ShippingAddress2 { get => _shippingAddress2; set => _shippingAddress2 = value ?? String.Empty; }
        [CompareField("shipping_city")]
        public string ShippingCity { get => _shippingCity; set => _shippingCity = value ?? String.Empty; }
        [CompareField("shipping_postcode")]
        public string ShippingPostcode { get => _shippingPostcode; set => _shippingPostcode = value ?? String.Empty; }
        [CompareField("shipping_country")]
        public string ShippingCountry { get => _shippingCountry; set => _shippingCountry = value ?? String.Empty; }
        [CompareField("shipping_country_id")]
        public int ShippingCountryId { get; set; }
        [CompareField("shipping_zone")]
        public string ShippingZone { get => _shippingZone; set => _shippingZone = value ?? String.Empty; }
        [CompareField("shipping_zone_id")]
        public int ShippingZoneId { get; set; }
        [CompareField("shipping_address_format")]
        public string ShippingAddressFormat { get => _shippingAddressFormat; set => _shippingAddressFormat = value ?? String.Empty; }
        [CompareField("shipping_custom_field")]
        public string ShippingCustomField { get => _shippingCustomField; set => _shippingCustomField = value ?? String.Empty; }
        [CompareField("shipping_method")]
        public string ShippingMethod { get => _shippingMethod; set => _shippingMethod = value ?? String.Empty; }
        [CompareField("shipping_code")]
        public string ShippingCode { get => _shippingCode; set => _shippingCode = value ?? String.Empty; }
        public string Comment { get => _comment; set => _comment = value ?? String.Empty; }
        public decimal Total { get; set; }
        [CompareField("order_status_id")]
        public int OrderStatusId { get; set; }
        [CompareField("affiliate_id")]
        public int AffiliateId { get; set; }
        public decimal Commission { get; set; }
        [CompareField("marketing_id")]
        public int MarketingId { get; set; }
        public string Tracking { get => _tracking; set => _tracking = value ?? String.Empty; }
        [CompareField("language_id")]
        public int LanguageId { get; set; }
        [CompareField("currency_id")]
        public int CurrencyId { get; set; }
        [CompareField("currency_code")]
        public string CurrencyCode { get => _currencyCode; set => _currencyCode = value ?? String.Empty; }
        [CompareField("currency_value")]
        public decimal CurrencyValue { get; set; }
        public string IP { get => _iP; set => _iP = value ?? String.Empty; }
        [CompareField("forwarded_ip")]
        public string ForwardedIp { get => _forwardedIp; set => _forwardedIp = value ?? String.Empty; }
        [CompareField("user_agent")]
        public string UserAgent { get => _userAgent; set => _userAgent = value ?? String.Empty; }
        [CompareField("accept_language")]
        public string AcceptLanguage { get => _acceptLanguage; set => _acceptLanguage = value ?? String.Empty; }
        [CompareField("date_added")]
        public DateTime DateAdded { get; set; }
        [CompareField("date_modified")]
        public DateTime DateModified { get; set; }

        #endregion



        public static async Task<Order?> GetOrderAsync(int order_id, string connectionString)
        {
            using MySqlController2 controller = new MySqlController2();
            controller.AddParameter("@ORDER_ID", order_id);
            DataRow? row = await controller.SelectRowAsync("SELECT * FROM `order` WHERE order_id = @ORDER_ID");
            return row is null ? null : ObjectErweiterung.DataRowZuObjekt(new Order(), row);
        }

        internal (string keys, string values) GetInsertProperties(MySqlController2? mySqlController = null)
        {
            StringBuilder keys = new StringBuilder();
            #region Keys
            keys.Append("invoice_no,");
            keys.Append("invoice_prefix,");
            keys.Append("store_id,");
            keys.Append("store_name,");
            keys.Append("store_url,");
            keys.Append("customer_id,");
            keys.Append("customer_group_id,");
            keys.Append("firstname,");
            keys.Append("lastname,");
            keys.Append("email,");
            keys.Append("telephone,");
            keys.Append("fax,");
            keys.Append("custom_field,");
            keys.Append("payment_firstname,");
            keys.Append("payment_lastname,");
            keys.Append("payment_company,");
            keys.Append("payment_address_1,");
            keys.Append("payment_address_2,");
            keys.Append("payment_city,");
            keys.Append("payment_postcode,");
            keys.Append("payment_country,");
            keys.Append("payment_country_id,");
            keys.Append("payment_zone,");
            keys.Append("payment_zone_id,");
            keys.Append("payment_address_format,");
            keys.Append("payment_custom_field,");
            keys.Append("payment_method,");
            keys.Append("payment_code,");
            keys.Append("shipping_firstname,");
            keys.Append("shipping_lastname,");
            keys.Append("shipping_company,");
            keys.Append("shipping_address_1,");
            keys.Append("shipping_address_2,");
            keys.Append("shipping_city,");
            keys.Append("shipping_postcode,");
            keys.Append("shipping_country,");
            keys.Append("shipping_country_id,");
            keys.Append("shipping_zone,");
            keys.Append("shipping_zone_id,");
            keys.Append("shipping_address_format,");
            keys.Append("shipping_custom_field,");
            keys.Append("shipping_method,");
            keys.Append("shipping_code,");
            keys.Append("comment,");
            keys.Append("total,");
            keys.Append("order_status_id,");
            keys.Append("affiliate_id,");
            keys.Append("commission,");
            keys.Append("marketing_id,");
            keys.Append("tracking,");
            keys.Append("language_id,");
            keys.Append("currency_id,");
            keys.Append("currency_code,");
            keys.Append("currency_value,");
            keys.Append("ip,");
            keys.Append("forwarded_ip,");
            keys.Append("user_agent,");
            keys.Append("accept_language,");
            keys.Append("date_added,");
            keys.Append("date_modified,");
            #endregion

            StringBuilder values = new StringBuilder();
            #region Values
            values.Append("@invoice_no,");
            values.Append("@invoice_prefix,");
            values.Append("@store_id,");
            values.Append("@store_name,");
            values.Append("@store_url,");
            values.Append("@customer_id,");
            values.Append("@customer_group_id,");
            values.Append("@firstname,");
            values.Append("@lastname,");
            values.Append("@email,");
            values.Append("@telephone,");
            values.Append("@fax,");
            values.Append("@custom_field,");
            values.Append("@payment_firstname,");
            values.Append("@payment_lastname,");
            values.Append("@payment_company,");
            values.Append("@payment_address_1,");
            values.Append("@payment_address_2,");
            values.Append("@payment_city,");
            values.Append("@payment_postcode,");
            values.Append("@payment_country,");
            values.Append("@payment_country_id,");
            values.Append("@payment_zone,");
            values.Append("@payment_zone_id,");
            values.Append("@payment_address_format,");
            values.Append("@payment_custom_field,");
            values.Append("@payment_method,");
            values.Append("@payment_code,");
            values.Append("@shipping_firstname,");
            values.Append("@shipping_lastname,");
            values.Append("@shipping_company,");
            values.Append("@shipping_address_1,");
            values.Append("@shipping_address_2,");
            values.Append("@shipping_city,");
            values.Append("@shipping_postcode,");
            values.Append("@shipping_country,");
            values.Append("@shipping_country_id,");
            values.Append("@shipping_zone,");
            values.Append("@shipping_zone_id,");
            values.Append("@shipping_address_format,");
            values.Append("@shipping_custom_field,");
            values.Append("@shipping_method,");
            values.Append("@shipping_code,");
            values.Append("@comment,");
            values.Append("@total,");
            values.Append("@order_status_id,");
            values.Append("@affiliate_id,");
            values.Append("@commission,");
            values.Append("@marketing_id,");
            values.Append("@tracking,");
            values.Append("@language_id,");
            values.Append("@currency_id,");
            values.Append("@currency_code,");
            values.Append("@currency_value,");
            values.Append("@ip,");
            values.Append("@forwarded_ip,");
            values.Append("@user_agent,");
            values.Append("@accept_language,");
            values.Append("@date_added,");
            values.Append("@date_modified,");
            #endregion

            if (mySqlController is not null)
            {
                mySqlController.AddParameter("@invoice_no", InvoiceNo);
                mySqlController.AddParameter("@invoice_prefix", InvoicePrefix);
                mySqlController.AddParameter("@store_id", StoreId);
                mySqlController.AddParameter("@store_name", StoreName);
                mySqlController.AddParameter("@store_url", StoreUrl);
                mySqlController.AddParameter("@customer_id", CustomerId);
                mySqlController.AddParameter("@customer_group_id", CustomeGroupId);
                mySqlController.AddParameter("@firstname", Firstname);
                mySqlController.AddParameter("@lastname", Lastname);
                mySqlController.AddParameter("@email", Email);
                mySqlController.AddParameter("@telephone", Telephone);
                mySqlController.AddParameter("@fax", Fax);
                mySqlController.AddParameter("@custom_field", CustomField);
                mySqlController.AddParameter("@payment_firstname", PaymentFirstname);
                mySqlController.AddParameter("@payment_lastname", PaymentLastname);
                mySqlController.AddParameter("@payment_company", PaymentCompany);
                mySqlController.AddParameter("@payment_address_1", PaymentAddress1);
                mySqlController.AddParameter("@payment_address_2", PaymentAddress2);
                mySqlController.AddParameter("@payment_city", PaymentCity);
                mySqlController.AddParameter("@payment_postcode", PaymentPostcode);
                mySqlController.AddParameter("@payment_country", PaymentCountry);
                mySqlController.AddParameter("@payment_country_id", PaymentCountryId);
                mySqlController.AddParameter("@payment_zone", PaymentZone);
                mySqlController.AddParameter("@payment_zone_id", PaymentZoneId);
                mySqlController.AddParameter("@payment_address_format", PaymentAddressFormat);
                mySqlController.AddParameter("@payment_custom_field", PaymentCustomField);
                mySqlController.AddParameter("@payment_method", PaymentMethod);
                mySqlController.AddParameter("@payment_code", PaymentCode);
                mySqlController.AddParameter("@shipping_firstname", ShippingFirstname);
                mySqlController.AddParameter("@shipping_lastname", ShippingLastname);
                mySqlController.AddParameter("@shipping_company", ShippingCompany);
                mySqlController.AddParameter("@shipping_address_1", ShippingAddress1);
                mySqlController.AddParameter("@shipping_address_2", ShippingAddress2);
                mySqlController.AddParameter("@shipping_city", ShippingCity);
                mySqlController.AddParameter("@shipping_postcode", ShippingPostcode);
                mySqlController.AddParameter("@shipping_country", ShippingCountry);
                mySqlController.AddParameter("@shipping_country_id", ShippingCountryId);
                mySqlController.AddParameter("@shipping_zone", ShippingZone);
                mySqlController.AddParameter("@shipping_zone_id", ShippingZoneId);
                mySqlController.AddParameter("@shipping_address_format", ShippingAddressFormat);
                mySqlController.AddParameter("@shipping_custom_field", ShippingCustomField);
                mySqlController.AddParameter("@shipping_method", ShippingMethod);
                mySqlController.AddParameter("@shipping_code", ShippingCode);
                mySqlController.AddParameter("@comment", Comment);
                mySqlController.AddParameter("@total", Total);
                mySqlController.AddParameter("@order_status_id", OrderStatusId);
                mySqlController.AddParameter("@affiliate_id", AffiliateId);
                mySqlController.AddParameter("@commission", Commission);
                mySqlController.AddParameter("@marketing_id", MarketingId);
                mySqlController.AddParameter("@tracking", Tracking);
                mySqlController.AddParameter("@language_id", LanguageId);
                mySqlController.AddParameter("@currency_id", CurrencyId);
                mySqlController.AddParameter("@currency_code", CurrencyCode);
                mySqlController.AddParameter("@currency_value", CurrencyValue);
                mySqlController.AddParameter("@ip", IP);
                mySqlController.AddParameter("@forwarded_ip", ForwardedIp);
                mySqlController.AddParameter("@user_agent", UserAgent);
                mySqlController.AddParameter("@accept_language", AcceptLanguage);
                mySqlController.AddParameter("@date_added", DateAdded);
                mySqlController.AddParameter("@date_modified", DateModified);
            }

            return (keys.ToString(), values.ToString());


        }

        internal string GetUpdateProperties(MySqlController2? mySqlController = null)
        {
            StringBuilder sb = new StringBuilder();
            sb.AppendLine("invoice_no = @invoice_no,");
            sb.AppendLine("invoice_prefix = @invoice_prefix,");
            sb.AppendLine("store_id = @store_id,");
            sb.AppendLine("store_name = @store_name,");
            sb.AppendLine("store_url = @store_url,");
            sb.AppendLine("customer_id = @customer_id,");
            sb.AppendLine("customer_group_id = @customer_group_id,");
            sb.AppendLine("firstname = @firstname,");
            sb.AppendLine("lastname = @lastname,");
            sb.AppendLine("email = @email,");
            sb.AppendLine("telephone = @telephone,");
            sb.AppendLine("fax = @fax,");
            sb.AppendLine("custom_field = @custom_field,");
            sb.AppendLine("payment_firstname = @payment_firstname,");
            sb.AppendLine("payment_lastname = @payment_lastname,");
            sb.AppendLine("payment_company = @payment_company,");
            sb.AppendLine("payment_address_1 = @payment_address_1,");
            sb.AppendLine("payment_address_2 = @payment_address_2,");
            sb.AppendLine("payment_city = @payment_city,");
            sb.AppendLine("payment_postcode = @payment_postcode,");
            sb.AppendLine("payment_country = @payment_country,");
            sb.AppendLine("payment_country_id = @payment_country_id,");
            sb.AppendLine("payment_zone = @payment_zone,");
            sb.AppendLine("payment_zone_id = @payment_zone_id,");
            sb.AppendLine("payment_address_format = @payment_address_format,");
            sb.AppendLine("payment_custom_field = @payment_custom_field,");
            sb.AppendLine("payment_method = @payment_method,");
            sb.AppendLine("payment_code = @payment_code,");
            sb.AppendLine("shipping_firstname = @shipping_firstname,");
            sb.AppendLine("shipping_lastname = @shipping_lastname,");
            sb.AppendLine("shipping_company = @shipping_company,");
            sb.AppendLine("shipping_address_1 = @shipping_address_1,");
            sb.AppendLine("shipping_address_2 = @shipping_address_2,");
            sb.AppendLine("shipping_city = @shipping_city,");
            sb.AppendLine("shipping_postcode = @shipping_postcode,");
            sb.AppendLine("shipping_country = @shipping_country,");
            sb.AppendLine("shipping_country_id = @shipping_country_id,");
            sb.AppendLine("shipping_zone = @shipping_zone,");
            sb.AppendLine("shipping_zone_id = @shipping_zone_id,");
            sb.AppendLine("shipping_address_format = @shipping_address_format,");
            sb.AppendLine("shipping_custom_field = @shipping_custom_field,");
            sb.AppendLine("shipping_method = @shipping_method,");
            sb.AppendLine("shipping_code = @shipping_code,");
            sb.AppendLine("comment = @comment,");
            sb.AppendLine("total = @total,");
            sb.AppendLine("order_status_id = @order_status_id,");
            sb.AppendLine("affiliate_id = @affiliate_id,");
            sb.AppendLine("commission = @commission,");
            sb.AppendLine("marketing_id = @marketing_id,");
            sb.AppendLine("tracking = @tracking,");
            sb.AppendLine("language_id = @language_id,");
            sb.AppendLine("currency_id = @currency_id,");
            sb.AppendLine("currency_code = @currency_code,");
            sb.AppendLine("currency_value = @currency_value,");
            sb.AppendLine("ip = @ip,");
            sb.AppendLine("forwarded_ip = @forwarded_ip,");
            sb.AppendLine("user_agent = @user_agent,");
            sb.AppendLine("accept_language = @accept_language,");
            sb.AppendLine("date_added = @date_added,");
            sb.AppendLine("date_modified = @date_modified,");


            if (mySqlController is not null)
            {
                mySqlController.AddParameter("@order_id", OrderId);
                mySqlController.AddParameter("@invoice_no", InvoiceNo);
                mySqlController.AddParameter("@invoice_prefix", InvoicePrefix);
                mySqlController.AddParameter("@store_id", StoreId);
                mySqlController.AddParameter("@store_name", StoreName);
                mySqlController.AddParameter("@store_url", StoreUrl);
                mySqlController.AddParameter("@customer_id", CustomerId);
                mySqlController.AddParameter("@customer_group_id", CustomeGroupId);
                mySqlController.AddParameter("@firstname", Firstname);
                mySqlController.AddParameter("@lastname", Lastname);
                mySqlController.AddParameter("@email", Email);
                mySqlController.AddParameter("@telephone", Telephone);
                mySqlController.AddParameter("@fax", Fax);
                mySqlController.AddParameter("@custom_field", CustomField);
                mySqlController.AddParameter("@payment_firstname", PaymentFirstname);
                mySqlController.AddParameter("@payment_lastname", PaymentLastname);
                mySqlController.AddParameter("@payment_company", PaymentCompany);
                mySqlController.AddParameter("@payment_address_1", PaymentAddress1);
                mySqlController.AddParameter("@payment_address_2", PaymentAddress2);
                mySqlController.AddParameter("@payment_city", PaymentCity);
                mySqlController.AddParameter("@payment_postcode", PaymentPostcode);
                mySqlController.AddParameter("@payment_country", PaymentCountry);
                mySqlController.AddParameter("@payment_country_id", PaymentCountryId);
                mySqlController.AddParameter("@payment_zone", PaymentZone);
                mySqlController.AddParameter("@payment_zone_id", PaymentZoneId);
                mySqlController.AddParameter("@payment_address_format", PaymentAddressFormat);
                mySqlController.AddParameter("@payment_custom_field", PaymentCustomField);
                mySqlController.AddParameter("@payment_method", PaymentMethod);
                mySqlController.AddParameter("@payment_code", PaymentCode);
                mySqlController.AddParameter("@shipping_firstname", ShippingFirstname);
                mySqlController.AddParameter("@shipping_lastname", ShippingLastname);
                mySqlController.AddParameter("@shipping_company", ShippingCompany);
                mySqlController.AddParameter("@shipping_address_1", ShippingAddress1);
                mySqlController.AddParameter("@shipping_address_2", ShippingAddress2);
                mySqlController.AddParameter("@shipping_city", ShippingCity);
                mySqlController.AddParameter("@shipping_postcode", ShippingPostcode);
                mySqlController.AddParameter("@shipping_country", ShippingCountry);
                mySqlController.AddParameter("@shipping_country_id", ShippingCountryId);
                mySqlController.AddParameter("@shipping_zone", ShippingZone);
                mySqlController.AddParameter("@shipping_zone_id", ShippingZoneId);
                mySqlController.AddParameter("@shipping_address_format", ShippingAddressFormat);
                mySqlController.AddParameter("@shipping_custom_field", ShippingCustomField);
                mySqlController.AddParameter("@shipping_method", ShippingMethod);
                mySqlController.AddParameter("@shipping_code", ShippingCode);
                mySqlController.AddParameter("@comment", Comment);
                mySqlController.AddParameter("@total", Total);
                mySqlController.AddParameter("@order_status_id", OrderStatusId);
                mySqlController.AddParameter("@affiliate_id", AffiliateId);
                mySqlController.AddParameter("@commission", Commission);
                mySqlController.AddParameter("@marketing_id", MarketingId);
                mySqlController.AddParameter("@tracking", Tracking);
                mySqlController.AddParameter("@language_id", LanguageId);
                mySqlController.AddParameter("@currency_id", CurrencyId);
                mySqlController.AddParameter("@currency_code", CurrencyCode);
                mySqlController.AddParameter("@currency_value", CurrencyValue);
                mySqlController.AddParameter("@ip", IP);
                mySqlController.AddParameter("@forwarded_ip", ForwardedIp);
                mySqlController.AddParameter("@user_agent", UserAgent);
                mySqlController.AddParameter("@accept_language", AcceptLanguage);
                mySqlController.AddParameter("@date_added", DateAdded);
                mySqlController.AddParameter("@date_modified", DateModified);
            }

            return sb.ToString();
        }

        internal static async Task<T?> GetOrderAsync<T>(T order, int order_id, string connectionString) where T : Order
        {
            using MySqlController2 mySqlController = new MySqlController2(connectionString);

            mySqlController.AddParameter("@order_id", order_id);
            DataRow? row = await mySqlController.SelectRowAsync("SELECT * FROM `order` WHERE order_id = @order_id");
            return row == null ? null : ObjectErweiterung.DataRowZuObjekt<T>(order, row);
        }
    }
}
