﻿using KarleyLibrary.Attributes;
using System;
using System.Threading.Tasks;

namespace WK5.Core.OpenCart.Karley
{
    public class MachMichProduct : Product
    {
        private string _designProductId = String.Empty;
        private string _designProductTitleImg = String.Empty;

        [CompareField("affiliate_amount")]
        public decimal AffiliateAmount { get; set; }
        [CompareField("affiliate_id")]
        public int AffiliateId { get; set; }
        [CompareField("design_product_id")]
        public string DesignProductId { get => _designProductId; set => _designProductId = value ?? String.Empty; }
        [CompareField("design_product_title_img")]
        public string DesignProductTitleImg { get => _designProductTitleImg; set => _designProductTitleImg = value ?? String.Empty; }
        public static async Task<MachMichProduct?> GetProductAsync(int product_id)
        {
            return await GetProductAsync<MachMichProduct>(new MachMichProduct(), product_id, GlobalConfig.MachMichMysql);
        }

        public static async Task<MachMichProduct?> GetProductAsync(string model)
        {
            return await GetProductAsync<MachMichProduct>(new MachMichProduct(), model, GlobalConfig.MachMichMysql);
        }

        public async Task UpdateProductAsync()
        {
            using MySqlController2 mySqlController = new MySqlController2(GlobalConfig.MachMichMysql);

            string baseProps = GetUpdateProperties(mySqlController);

            string sql = $@"UPDATE `product` SET
{baseProps}
affiliate_amount = @affiliate_amount,
affiliate_id = @affiliate_id,
design_product_id = @design_product_id,
design_product_title_img = @design_product_title_img

WHERE product_id = @product_id";

            mySqlController.AddParameter("@affiliate_amount", AffiliateAmount);
            mySqlController.AddParameter("@affiliate_id", AffiliateId);
            mySqlController.AddParameter("@design_product_id", DesignProductId);
            mySqlController.AddParameter("@design_product_title_img", DesignProductTitleImg);

            await mySqlController.QueryAsync(sql);
        }

        public static async Task UpdateProductAsync(MachMichProduct product)
        {
            await product.UpdateProductAsync();
        }
    }
}
