﻿using KarleyLibrary.Attributes;
using MbeSoap;
using System;
using System.Threading.Tasks;

namespace WK5.Core.OpenCart.MachMich
{
    public class MachMichOrder : Order
    {
        private string _adminComment = String.Empty;

        [CompareField("date_invoice")]
        public DateTime DateInvoice { get; set; }
        [CompareField("gutschrift_id")]
        public int GutschriftId { get; set; }
        [CompareField("gutschrift_order_id")]
        public int GutschriftOrderId { get; set; }
        [CompareField("admin_comment")]
        public string AdminComment { get => _adminComment; set => _adminComment = value ?? String.Empty; }
        public bool Exported { get; set; } = false;
        public bool Archiviert { get; set; } = false;

        public static async Task<MachMichOrder?> GetOrderAsync(int order_id)
        {
            return await GetOrderAsync<MachMichOrder>(new MachMichOrder(), order_id, GlobalConfig.MachMichMysql);
        }

        public async Task<RecipientType> ToRecipientType()
        {
            Country? country = await Country.GetCountryAsync(ShippingCountryId, GlobalConfig.MachMichMysql);



            string company = String.IsNullOrWhiteSpace(ShippingCompany) ? $"MM-{OrderId}" : ShippingCompany;

            string adress2 = "";
            if (String.IsNullOrWhiteSpace(ShippingAddress2))
            {
                if (String.IsNullOrWhiteSpace(ShippingCompany))
                {
                    adress2 = "";
                }
                else
                {
                    adress2 = $"MM-{OrderId}";
                }
            }
            else
            {
                adress2 = ShippingAddress2;
            }

            return new RecipientType
            {
                Name = $"{Firstname} {Lastname}",
                Address = ShippingAddress1,
                Address2 = adress2,
                City = ShippingCity,
                ZipCode = ShippingPostcode,
                Email = Email,
                CompanyName = company,
                Country = country?.iso_code_2 ?? "de",
                Phone = Telephone
            };
        }

        public async Task UpdateOrderAsync()
        {
            using MySqlController2 mySqlController = new MySqlController2(GlobalConfig.MachMichMysql);
            string baseProps = GetUpdateProperties(mySqlController);

            string sql = $@"UPDATE `order` SET
{baseProps}
date_invoice = @date_invoice,
gutschrift_id = @gutschrift_id,
gutschrift_order_id = @gutschrift_order_id,
admin_comment = @admin_comment,
exported = @exported,
archiviert = @archiviert

WHERE order_id = @order_id";

            mySqlController.AddParameter("@date_invoice", DateInvoice);
            mySqlController.AddParameter("@gutschrift_id", GutschriftId);
            mySqlController.AddParameter("@gutschrift_order_id", GutschriftOrderId);
            mySqlController.AddParameter("@admin_comment", AdminComment);
            mySqlController.AddParameter("@exported", Exported);
            mySqlController.AddParameter("@archiviert", Archiviert);

            await mySqlController.QueryAsync(sql);

        }

        public async Task<int> InsertOrderAsync()
        {
            using MySqlController2 mySqlController = new MySqlController2(GlobalConfig.MachMichMysql);

            var (keys, values) = GetInsertProperties(mySqlController);

            string sql = $@"INSERT INTO `order`
({keys}date_invoice, gutschrift_id, gutschrift_order_id, admin_comment, exported, archiviert)
VALUES
({values}@date_invoice, @gutschrift_id, @gutschrift_order_id, @admin_comment, @exported, @archiviert)";

            mySqlController.AddParameter("@date_invoice", DateInvoice);
            mySqlController.AddParameter("@gutschrift_id", GutschriftId);
            mySqlController.AddParameter("@gutschrift_order_id", GutschriftOrderId);
            mySqlController.AddParameter("@admin_comment", AdminComment);
            mySqlController.AddParameter("@exported", Exported);
            mySqlController.AddParameter("@archiviert", Archiviert);

            await mySqlController.QueryAsync(sql);
            object? idObj = await mySqlController.FetchObjectAsync("SELECT LAST_INSERT_ID()");

            if (idObj is not null)
            {
                return Convert.ToInt32(idObj);
            }
            else
            {
                return 0;
            }
        }
    }
}
