﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace WK5.Core.OpenCart.Karley
{
    public class KarleyProductImage : ProductImage
    {
        public const string OPENCART_IMAGE_BASE = "https://www.karley.de/image/";

        public Task<string?> Download(string targetPath)
        {
            return Download(OPENCART_IMAGE_BASE, targetPath);
        }

        public static IAsyncEnumerable<KarleyProductImage> GetImagesAsync(int product_id, string connectionString)
        {
            return GetImagesAsync<KarleyProductImage>(product_id, connectionString);
        }

        public static IAsyncEnumerable<KarleyProductImage> GetImagesAsync(string model, string connectionString)
        {
            return GetImagesAsync<KarleyProductImage>(model, connectionString);
        }
    }
}
