﻿using System;
using System.Threading.Tasks;

namespace WK5.Core.OpenCart.Karley
{
    public class KarleyProductDescription : ProductDescription
    {
        public string? PDF { get; set; }

        public static async Task<KarleyProductDescription?> GetProductDescriptionAsync(int product_id)
        {
            return await GetProductDescriptionAsync<KarleyProductDescription>(new KarleyProductDescription(), product_id, GlobalConfig.KarleyMySql);
        }

        public async Task UpdateProductDescriptionAsync()
        {
            using MySqlController2 mySqlController = new MySqlController2(GlobalConfig.KarleyMySql);

            string baseProps = GetUpdateProperties(mySqlController);

            string sql = $@"UPDATE `product_description` SET
{baseProps}
pdf = @pdf

WHERE product_id = @product_id";

            mySqlController.AddParameter("@pdf", PDF ?? String.Empty);

            await mySqlController.QueryAsync(sql);
        }

        public static async Task UpdateProductDescriptionAsync(KarleyProductDescription description)
        {
            await description.UpdateProductDescriptionAsync();
        }
    }
}
