﻿using KarleyLibrary.Attributes;
using MbeSoap;
using System;
using System.Threading.Tasks;

namespace WK5.Core.OpenCart.Karley
{
    public class KarleyOrder : Order
    {
        private string _paymentTaxId = String.Empty;

        [CompareField("date_invoice")]
        public DateTime DateInvoice { get; set; }
        public string? IBAN { get; set; }
        public string? BIC { get; set; }
        public string? Kontoinhaber { get; set; }
        [CompareField("sepa_allowed")]
        public bool SepaAllowed { get; set; } = false;
        [CompareField("payment_tax_id")]
        public string PaymentTaxId { get => _paymentTaxId; set => _paymentTaxId = value ?? String.Empty; }

        public static async Task<KarleyOrder?> GetOrderAsync(int order_id)
        {
            return await GetOrderAsync<KarleyOrder>(new KarleyOrder(), order_id, GlobalConfig.KarleyMySql);
        }

        public async Task<RecipientType> ToRecipientType()
        {
            Country? country = await Country.GetCountryAsync(ShippingCountryId, GlobalConfig.KarleyMySql);



            string company = String.IsNullOrWhiteSpace(ShippingCompany) ? $"{OrderId}" : ShippingCompany;

            string adress2 = "";
            if (String.IsNullOrWhiteSpace(ShippingAddress2))
            {
                if (String.IsNullOrWhiteSpace(ShippingCompany))
                {
                    adress2 = "";
                }
                else
                {
                    adress2 = $"{OrderId}";
                }
            }
            else
            {
                adress2 = ShippingAddress2;
            }

            return new RecipientType
            {
                Name = $"{Firstname} {Lastname}",
                Address = ShippingAddress1,
                Address2 = adress2,
                City = ShippingCity,
                ZipCode = ShippingPostcode,
                Email = Email,
                CompanyName = company,
                Country = country?.iso_code_2 ?? "de",
                Phone = Telephone
            };
        }

        public async Task UpdateOrderAsync()
        {
            using MySqlController2 mySqlController = new MySqlController2(GlobalConfig.MachMichMysql);
            string baseProps = GetUpdateProperties(mySqlController);

            string sql = $@"UPDATE `order` SET
{baseProps}
date_invoice = @date_invoice,
iban = @iban,
bic = @bic,
kontoinhaber = @kontoinhaber,
sepa_allowed = @sepa_allowed,
payment_tax_id = @payment_tax_id

WHERE order_id = @order_id";

            mySqlController.AddParameter("@date_invoice", DateInvoice);
            mySqlController.AddParameter("@iban", IBAN);
            mySqlController.AddParameter("@bic", BIC);
            mySqlController.AddParameter("@kontoinhaber", Kontoinhaber);
            mySqlController.AddParameter("@sepa_allowed", SepaAllowed);
            mySqlController.AddParameter("@payment_tax_id", PaymentTaxId);

            await mySqlController.QueryAsync(sql);

        }
    }
}
