﻿using KarleyLibrary.Erweiterungen;
using System.Data;
using System.Threading.Tasks;

namespace WK5.Core.OpenCart
{
    public class CustomerGroupDescription
    {
        #region Properties
        public int customer_group_id { get; set; }
        public int language_id { get; set; }
        public string? name { get; set; }
        public string? description { get; set; }

        #endregion

        public static async Task<CustomerGroupDescription?> GetCustomerGroupDescriptionAsync(int customer_group_id, string connectionString)
        {

            using MySqlController2 mySqlController = new MySqlController2(connectionString);

            mySqlController.AddParameter("@CUSTOMER_GROUP_ID", customer_group_id);
            DataRow row = await mySqlController.SelectRowAsync("SELECT * FROM customer_group_description WHERE customer_group_id = @CUSTOMER_GROUP_ID");

            return row == null ? null : ObjectErweiterung.DataRowZuObjekt(new CustomerGroupDescription(), row);
        }
    }
}
