﻿using KarleyLibrary.Erweiterungen;
using System.ComponentModel.DataAnnotations;
using System.Data;
using System.Threading.Tasks;

namespace WK5.Core.OpenCart
{
    public class Country
    {
        [MaxLength(11)]
        public int country_id { get; set; }

        [MaxLength(128)]
        public string? name { get; set; }

        [MaxLength(2)]
        public string? iso_code_2 { get; set; }

        [MaxLength(3)]
        public string? iso_code_3 { get; set; }

        public string? address_format { get; set; }

        public bool postcode_required { get; set; }
        public bool status { get; set; }

        public static async Task<Country?> GetCountryAsync(int country_id, string connectionString)
        {
            using MySqlController2 controller = new MySqlController2(connectionString);
            controller.AddParameter("@COUNTRY_ID", country_id);
            DataRow? row = await controller.SelectRowAsync("SELECT * FROM `country` WHERE country_id = @COUNTRY_ID");
            return row is null ? null : ObjectErweiterung.DataRowZuObjekt(new Country(), row);
        }
    }
}
