﻿using System.Threading.Tasks;

namespace WK5.Core.OnlineShop
{
    /// <summary>
    /// Stellt Funktionen zur Arbeit mit dem Onlineshop zur Verfügung. Diese Klasse ist nicht Threadsafe und kann nicht vererbt werden.
    /// </summary>
    public sealed class ShopHelper
    {
        private readonly MySqlController2 mySqlController = new MySqlController2();

        /// <summary>
        /// Aktualisiert den Status für eine Order im Onlineshop.
        /// <para>Es ist sinnvoll anschließend noch die Aktualisierung in der Order Historie zu hinterlegen. Dazu kann die Methode <see cref="AddOrderHistory(OrderStatus, string, bool)"/> verwendet werden.</para>
        /// </summary>
        /// <param name="order_id"></param>
        /// <param name="newStatus"></param>
        public async Task UpdateOrderStatusAsync(int order_id, OrderStatus newStatus)
        {
            mySqlController.AddParameter("@ORDER_ID", order_id);
            mySqlController.AddParameter("@ORDER_STATUS_ID", (int)newStatus);
            await mySqlController.QueryAsync("UPDATE `order` SET `order_status_id` = @ORDER_STATUS_ID WHERE `order_id` = @ORDER_ID");
        }

        /// <summary>
        /// Fügt eine neue History zu einem Auftrag hinzu
        /// </summary>
        /// <param name="newStatus"></param>
        /// <param name="comment"></param>
        /// <param name="notify">Gibt an, ob der Kunde den Status in seinem Kundenkonto sehen soll, oder nicht.</param>
        public async Task AddOrderHistoryAsync(int order_id, OrderStatus newStatus, string comment, bool notify = true)
        {
            mySqlController.AddParameter("@ORDER_ID", order_id);
            mySqlController.AddParameter("@ORDER_STATUS_ID", (int)newStatus);
            mySqlController.AddParameter("@NOTIFY", notify ? 1 : 0);
            mySqlController.AddParameter("@COMMENT", comment);
            await mySqlController.QueryAsync("INSERT INTO `order_history` (`order_id`, `order_status_id`, `notify`, `comment`, `date_added`) VALUES (@ORDER_ID, @ORDER_STATUS_ID, @NOTIFY, @COMMENT, CURRENT_TIMESTAMP)");
        }

        public async Task UpdatePreiseAsync(string artikelnummer, decimal firmenPreis, decimal directShopPrice, int preisOption)
        {
            mySqlController.AddParameter("@FIRMENPREIS", firmenPreis);
            mySqlController.AddParameter("@DIRECTSHOPPRICE", directShopPrice);
            mySqlController.AddParameter("@ARTIKELNUMMER", artikelnummer);
            mySqlController.AddParameter("@preis_auf_anfrage", preisOption is 2 ? 1 : 0);
            mySqlController.AddParameter("@preis_nach_login", preisOption is 3 ? 1 : 0);
            await mySqlController.QueryAsync("UPDATE `product` SET `price` = @FIRMENPREIS, `directprice` = @DIRECTSHOPPRICE, preis_auf_anfrage = @preis_auf_anfrage, preis_nach_login = @preis_nach_login WHERE `model` = @ARTIKELNUMMER");
        }
    }
}
